<?php

namespace App\Console\Commands;

use App\Jobs\AutomationJob;
use App\Models\EmailAutomationMap;
use Carbon\Carbon;
use Illuminate\Console\Command;

class AutomationCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:automation-cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Automation cron work here';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $basicControl = basicControl();
        $params = ['emailThrottleTime' => $basicControl->emailThrottleTime, 'emailThrottleStatus' => $basicControl->emailThrottleStatus];
        $currenDate = Carbon::now()->toDateString();
        $currenTime = Carbon::now()->toTimeString();

        $sendEmailLists = EmailAutomationMap::where('status', 0)->whereDate('triggered_date', '<=', $currenDate)
            ->whereTime('triggered_time', '<=', $currenTime)->get();

        if (count($sendEmailLists) > 0) {
            foreach ($sendEmailLists as $sendEmailList) {
                $sendEmailList->status = 1;
                $sendEmailList->save();
                dispatch(new AutomationJob($sendEmailList, url('/'), $params));
            }
        }
    }
}
