<?php

namespace App\Console;

use App\Console\Commands\AutomationCron;
use App\Console\Commands\AutomationStaticsCron;
use App\Console\Commands\BulkEmailCheckDelete;
use App\Console\Commands\SingleSendCron;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{


    protected $commands = [
        SingleSendCron::class,
        AutomationCron::class,
        AutomationStaticsCron::class,
        BulkEmailCheckDelete::class,
    ];

    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command('app:single-send-cron')->everyMinute();
        $schedule->command('app:automation-cron')->everyMinute();
        $schedule->command('app:automation-statics-cron')->everyTwoMinutes();
        $schedule->command('app:app:bulk-email-check-delete')->daily();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
