<?php

namespace App\Exports;

use App\Models\BulkEmailCheck;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class BulkEmailResultExport implements FromCollection, WithHeadings
{
    private $type;
    private $utr;

    public function __construct($type, $utr)
    {
        $this->type = $type;
        $this->utr = $utr;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        if ($this->type == 'all') {
            return BulkEmailCheck::where('user_id', auth()->id())->where('utr', $this->utr)
                ->get()->map(function ($query) {
                    $data['Email'] = $query->email;
                    $data['Status'] = $query->status;
                    return $data;
                });
        } else {
            return BulkEmailCheck::where('user_id', auth()->id())->where('utr', $this->utr)->where('status', $this->type)
                ->get()->map(function ($query) {
                    $data['Email'] = $query->email;
                    $data['Status'] = $query->status;
                    return $data;
                });
        }
    }

    public function headings(): array
    {
        return [
            'Email',
            'Status'
        ];
    }
}
