<?php

namespace App\Exports;

use App\Models\Contact;
use App\Models\ContactType;
use App\Models\CustomField;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ContactExport implements FromCollection, WithHeadings
{
    private $search;
    private $type_id;

    //private $customField = [];

    public function __construct($request, $type_id)
    {
        $this->search = $request;
        $this->type_id = $type_id;
//        $fields = CustomField::own()->pluck('field_name');
//        foreach ($fields as $field) {
//            $this->customField[] = removeHyphenInString(ucfirst($field));
//        }
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $search = $this->search;
        $type_id = $this->type_id;

        ContactType::own(1)->select(['id', 'name'])->findOrFail($type_id);
        return Contact::own()->with('contactType')
            ->when(isset($search['first_name']), function ($query) use ($search) {
                $query->where('first_name', 'LIKE', '%' . $search['first_name'] . '%');
            })
            ->when(isset($search['last_name']), function ($query) use ($search) {
                $query->where('last_name', 'LIKE', '%' . $search['last_name'] . '%');
            })
            ->when(isset($search['email']), function ($query) use ($search) {
                $query->where('email', 'LIKE', '%' . $search['email'] . '%');
            })
            ->when($type_id != 1, function ($query) use ($search, $type_id) {
                $query->where('contact_type_id', $type_id);
            })
            ->orderBy('id', 'desc')
            ->get()->map(function ($query) {
                $data['First Name'] = $query->first_name;
                $data['Last Name'] = $query->last_name;
                $data['Email'] = $query->email;
                $data['Alt Email'] = $query->alt_email;
                $data['Country'] = $query->country;
                $data['State'] = $query->state;
                $data['City'] = $query->city;
                $data['Address Line1'] = $query->address_line1;
                $data['Address Line2'] = $query->address_line2;
                $data['State Province Region'] = $query->state_province_region;
                $data['Postal Code'] = $query->postal_code;
//                foreach ($query->custom_field as $custom) {
//                    if (in_array($custom->field_name, $this->customField)) {
//                        $data["$custom->field_name"] = $custom->field_value;
//                    }
//                }
                $data['Added At'] = dateTime($query->created_at, basicControl()->date_time_format);
                $data['Updated At'] = dateTime($query->updated_at, basicControl()->date_time_format);
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            "First Name",
            "Last Name",
            "Email",
            "Alt Email",
            "Country",
            "State",
            "City",
            "Address Line1",
            "Address Line2",
            "State Province Region",
            "Postal Code",
            "Added At",
            "Updated At"
        ];
    }
}
