<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportInvalidEmails implements FromArray, WithHeadings
{
    private $invalidEmails;

    public function __construct($invalidEmails)
    {
        $this->invalidEmails = $invalidEmails;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function array(): array
    {
        return array_map(function ($email) {
            return [$email];
        }, $this->invalidEmails);
    }

    public function headings(): array
    {
        return [
            'Email',
        ];
    }
}
