<?php

namespace App\Exports;

use App\Models\UnsubscribeClient;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportRecipient implements FromCollection, WithHeadings
{
    private $groupId;

    public function __construct($id)
    {
        $this->groupId = $id;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return UnsubscribeClient::own()->where('unsubscribe_groups_id', $this->groupId)
            ->orderBy('id', 'desc')
            ->get()->map(function ($query) {
                $data['Email'] = $query->email_address;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'Email',
        ];
    }
}
