<?php

namespace App\Exports;

use App\Models\SegmentEmail;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportSegmentEmail implements FromCollection, WithHeadings
{
    private $segmentId;
    private $search;

    public function __construct($request, $segmentId)
    {
        $this->segmentId = $segmentId;
        $this->search = $request;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $search = $this->search;
        return SegmentEmail::own()->where('segment_id', $this->segmentId)
            ->when(isset($search['firstname']), function ($query) use ($search) {
                $query->where('first_name', 'LIKE', '%' . $search['firstname'] . '%');
            })
            ->when(isset($search['lastname']), function ($query) use ($search) {
                $query->where('last_name', 'LIKE', '%' . $search['lastname'] . '%');
            })
            ->when(isset($search['email_address']), function ($query) use ($search) {
                $query->where('email', 'LIKE', '%' . $search['email_address'] . '%');
            })
            ->orderBy('id', 'desc')->get()->map(function ($query) {
                $data['First Name'] = $query->first_name;
                $data['Last Name'] = $query->last_name;
                $data['Email Address'] = $query->email;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'First Name',
            'Last Name',
            'Email Address',
        ];
    }
}
