<?php

namespace App\Exports;

use App\Models\SingleSendActivity;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportSingleSendActivityEmail implements FromCollection, WithHeadings
{
    private $singleSendId;
    private $type;

    public function __construct($singleSendId, $type)
    {
        $this->singleSendId = $singleSendId;
        $this->type = $type;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return SingleSendActivity::own()->where('single_send_id', $this->singleSendId)
            ->where('type', $this->type)->orderBy('id', 'desc')
            ->get()->map(function ($query) {
                $data['Email'] = $query->email;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'Email',
        ];
    }
}
