<?php

namespace App\Http\Controllers;

use App\Models\EmailAutomationMap;
use App\Models\SingleSend;
use App\Models\SingleSendActivity;
use App\Models\UnsubscribeClient;
use App\Models\UnsubscribeGroup;
use App\Models\User;
use App\Traits\WebhookNotify;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class UnsubscribePreferenceController extends Controller
{
    use WebhookNotify;

    public function preferenceShow($params)
    {
        if ($params) {
            $decryptedParams = Crypt::decrypt($params);
            if (isset($decryptedParams['0']) && isset($decryptedParams['1']) && isset($decryptedParams['2'])) {
                $ownerId = $decryptedParams['0'];
                $unsubscriberEmail = $decryptedParams['1'];
                $singleSendId = $decryptedParams['2'];

                $data['unsubscribeGroups'] = UnsubscribeGroup::where('user_id', $ownerId)->where('is_display', 1)->get();
                $data['unsubscriberEmail'] = $unsubscriberEmail;
                $data['ownerId'] = $ownerId;
                $data['singleSendId'] = $singleSendId;
                return view('unsubscribe_preference.index', $data);
            }
        }
    }

    public function preferenceSave(Request $request, $ownerId, $email, $singleSendId)
    {
        UnsubscribeClient::where('user_id', $ownerId)
            ->whereHas('unsubscribeGroup', function ($qq) {
                $qq->where('is_display', 1);
            })
            ->whereNotNull('unsubscribe_groups_id')
            ->where('email_address', $email)
            ->get()
            ->map(function ($query) {
                $query->delete();
            });

        if (isset($request->optOut) && count($request->optOut) > 0) {
            foreach ($request->optOut as $optKey => $opt) {
                $clientData[] = [
                    'user_id' => $ownerId,
                    'unsubscribe_groups_id' => $optKey,
                    'email_address' => $email,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            }
            UnsubscribeClient::insert($clientData);
        }

        singleSendActivitySave($ownerId, $singleSendId, $email, 4);
        $user = User::find($ownerId);
        $this->pushStatusUserWebhook($email, 'unsubscribe', $user ?? null);

        return redirect()->route('unsubscribePreference',
            ['params' => Crypt::encrypt([$ownerId, $email, $singleSendId])]
        )->with('success', 'Opt-Out Preferences Updated!');
    }

    public function trackEmail($utr, $token, $email)
    {
        $singleSend = SingleSend::where('utr', $utr)->first();
        if ($singleSend) {
            $tokenLists = $singleSend->unique_open_token;
            if (in_array($token, $tokenLists)) {
                $singleSend->unique_opens += 1;
                $updatedTokenLists = array_diff($tokenLists, [$token]);
                $singleSend->unique_open_token = $updatedTokenLists;
                $singleSend->save();

                singleSendActivitySave($singleSend->user_id, $singleSend->id, $email, 3);
                $this->pushStatusUserWebhook($email, 'unique_opens', $singleSend->user ?? null);
            }
            $singleSend->total_opens += 1;
            $singleSend->save();
            $this->pushStatusUserWebhook($email, 'opens', $singleSend->user ?? null);
        }
        return response()->json('ok');
    }

    public function automationTrack($id)
    {
        $recipient = EmailAutomationMap::find($id);
        if ($recipient) {
            $recipient->open_date = Carbon::now()->toDateString();
            $recipient->unique_opens = 1;
            $recipient->total_opens += 1;
            $recipient->save();
            $this->pushStatusUserWebhook($recipient->email_address, 'opens', $recipient->user ?? null);
        }
        return response()->json('ok');
    }

    public function automationUnsubscribe($params)
    {
        if ($params) {
            $decryptedParams = Crypt::decrypt($params);
            if (isset($decryptedParams['0'])) {
                $id = $decryptedParams['0'];
                $recipient = EmailAutomationMap::select(['id', 'user_id', 'unsubscribes', 'automation_id', 'email_address'])->with(['automation'])->find($id);
                if ($recipient) {
                    $recipient->unsubscribes = 1;
                    $recipient->save();

                    $unsubscribeGroupId = $recipient->automation->unsubscribe_group_id;
                    UnsubscribeClient::updateOrCreate(
                        [
                            'email_address' => $recipient->email_address,
                            'user_id' => $recipient->user_id,
                        ],
                        [
                            'user_id' => $recipient->user_id,
                            'unsubscribe_groups_id' => $unsubscribeGroupId != 0 ? $unsubscribeGroupId : null,
                            'email_address' => $recipient->email_address,
                        ]
                    );
                    $this->pushStatusUserWebhook($recipient->email_address, 'unsubscribes', $recipient->user ?? null);
                }
            }
            return view('unsubscribe_preference.success');
        }
    }
}
