<?php

namespace App\Http\Requests;

use App\Rules\UniqueFieldName;
use Illuminate\Foundation\Http\FormRequest;

class CustomFieldStoreRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'field_name' => ['required', 'regex:/^[A-Za-z0-9_]+$/', new UniqueFieldName],
            'field_type' => 'required|in:text,number,datetime-local',
        ];
    }
}
