<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PlanStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'plan_name' => 'required|min:2|max:100',
            'payment_frequency' => ['required', Rule::in(['monthly', 'yearly'])],
            'price' => 'required|numeric|min:0|not_in:0',
            'number_of_contacts' => 'required|integer|min:0',
            'number_of_emails' => 'required|integer|min:0',
            'sending_server' => ['required', Rule::in(['mailchimp', 'mailersend', 'mailgun', 'postmark', 'sendgrid', 'sendinblue', 'ses', 'smtp'])],

            'design_and_code_editors' => ['required', Rule::in(['0', '1'])],
            'automation' => ['required', Rule::in(['0', '1'])],
            'single_send' => ['required', Rule::in(['0', '1'])],
            'segmentation' => ['required', Rule::in(['0', '1'])],
            'custom_field' => ['required', Rule::in(['0', '1'])],
            'notify_recipient' => ['required', Rule::in(['0', '1'])],
            'activities' => ['required', Rule::in(['0', '1'])],
            'api_uses' => ['required', Rule::in(['0', '1'])],
            'status' => ['required', Rule::in(['0', '1'])],
        ];
    }
}
