<?php

namespace App\Http\Requests;

use App\Rules\UniqueEmailForSegment;
use Illuminate\Foundation\Http\FormRequest;

class SegmentEmailStoreRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required|min:1',
            'last_name' => 'required|min:1',
            'email' => ['required', 'email', new UniqueEmailForSegment()],
        ];
    }
}
