<?php

namespace App\Jobs;

use App\Models\ApiClient;
use App\Models\EmailTemplate;
use App\Models\SupportTicket;
use App\Traits\Upload;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class UserAllRecordDeleteJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Upload;

    public $user;

    /**
     * Create a new job instance.
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::table('api_clients')->where('user_id', $this->user->id)->delete();
        DB::table('user_activities')->where('user_id', $this->user->id)->delete();
        DB::table('user_kycs')->where('user_id', $this->user->id)->delete();
        DB::table('user_logins')->where('user_id', $this->user->id)->delete();

        DB::table('email_automation_maps')->where('user_id', $this->user->id)->delete();
        DB::table('automation_schedules')->where('user_id', $this->user->id)->delete();
        DB::table('automations')->where('user_id', $this->user->id)->delete();
        DB::table('contacts')->where('user_id', $this->user->id)->delete();
        DB::table('deposits')->where('user_id', $this->user->id)->delete();

        DB::table('funds')->where('user_id', $this->user->id)->delete();
        DB::table('notifications')->where('user_id', $this->user->id)->delete();

        DB::table('segment_emails')->where('user_id', $this->user->id)->delete();
        DB::table('segments')->where('user_id', $this->user->id)->delete();

        DB::table('senders')->where('user_id', $this->user->id)->delete();

        DB::table('single_send_activities')->where('user_id', $this->user->id)->delete();
        DB::table('single_sends')->where('user_id', $this->user->id)->delete();

        DB::table('subscription_purchases')->where('user_id', $this->user->id)->delete();
        DB::table('transactions')->where('user_id', $this->user->id)->delete();
        DB::table('unsubscribe_clients')->where('user_id', $this->user->id)->delete();
        DB::table('unsubscribe_groups')->where('user_id', $this->user->id)->delete();

        SupportTicket::where('user_id', $this->user->id)->get()->map(function ($item) {
            $item->messages()->get()->map(function ($message) {
                if (count($message->attachments) > 0) {
                    foreach ($message->attachments as $img) {
                        $this->fileDelete($img->driver, $img->file);
                        $img->delete();
                    }
                }
            });
            $item->messages()->delete();
            $item->delete();
        });

        EmailTemplate::where('user_id', $this->user->id)->get()->map(function ($query) {
            $this->fileDelete($query->driver, $query->preview_image);
            $query->delete();
        });

        DB::table('contact_types')->where('user_id', $this->user->id)->delete();
        DB::table('custom_fields')->where('user_id', $this->user->id)->delete();

    }
}
