<?php

namespace App\Mail;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SenderVerifyMail extends Mailable
{
    use Queueable, SerializesModels;

    public $sender;
    public $url;
    public $theme;
    public $logo;

    /**
     * Create a new message instance.
     */
    public function __construct($sender)
    {
        $this->theme = template();
        $this->logo = getFile(basicControl()->logo_driver, basicControl()->logo);
        $this->sender = $sender;
        $this->url = route('senderVerifyMail', $this->sender->utr);
    }

    public function build()
    {
        $mailMessage = $this->subject("Please Verify Your Sender Identity")
            ->from(basicControl()->sender_email, basicControl()->sender_email_name);

        $mailMessage->view($this->theme . 'user.senders.mail', [
            'from_email' => $this->sender->from_email,
            'reply_to_email' => $this->sender->reply_to_email,
            'date' => Carbon::now()->format(basicControl()->date_time_format),
            'logo' => $this->logo,
            'url' => $this->url,
        ]);
    }
}
