<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Support\Facades\Config;
use Illuminate\Queue\SerializesModels;

class SingleSendMail extends Mailable
{
    use Queueable, SerializesModels;

    public $singleSend;
    public $htmlCode;
    public $url;

    /**
     * Create a new message instance.
     */
    public function __construct($singleSend, $htmlCode, $receiverEmail)
    {
        $this->singleSend = $singleSend;
        $this->htmlCode = $htmlCode;

        $token = strRandom(15);
        $existingData = $this->singleSend->unique_open_token;
        $existingData[] = $token;
        $this->singleSend->unique_open_token = $existingData;
        $this->singleSend->save();
        $this->url = route('trackEmail', [$this->singleSend->utr, $token, $receiverEmail]);
    }

    public function build()
    {
        return $this->view('email.single_send_email')
            ->subject($this->singleSend->subject)
            ->with([
                'htmlCode' => $this->htmlCode,
                'emailTrack' => $this->url,
            ])
            ->from($this->singleSend->from_sender, $this->singleSend->sender_name)
            ->replyTo($this->singleSend->reply_to);
    }
}
