<?php

namespace App\Models;

use App\Traits\TimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Automation extends Model
{
    use HasFactory, SoftDeletes, TimeZone;

    protected $guarded = ['id'];

    public function scopeOwn($query, $userId = null)
    {
        if ($userId) {
            return $query->where('user_id', $userId);
        }
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function automationSchedule()
    {
        return $this->hasMany(AutomationSchedule::class, 'automation_id');
    }

    public function emailAutomationMaps()
    {
        return $this->hasMany(EmailAutomationMap::class, 'automation_id');
    }

    public function unsubscribeGroup()
    {
        return $this->belongsTo(UnsubscribeGroup::class, 'unsubscribe_group_id');
    }

    public function contactType()
    {
        return $this->belongsTo(ContactType::class, 'automation_for')->withTrashed();
    }

    public function segment()
    {
        return $this->belongsTo(Segment::class, 'automation_for')->withTrashed();
    }

    public function getPercent()
    {
        return [
            'deliveredPercent' => ($this->total_triggered ? getAmount((100 * $this->total_delivered) / $this->total_triggered, 2) : 0),
            'bouncesPercent' => ($this->total_triggered ? getAmount((100 * $this->total_bounces) / $this->total_triggered, 2) : 0),
            'uniqueOpenPercent' => ($this->total_delivered ? getAmount((100 * $this->total_unique_opens) / $this->total_delivered, 2) : 0),
            'unsubscribesPercent' => ($this->total_delivered ? getAmount((100 * $this->total_unsubscribe) / $this->total_delivered, 2) : 0),
        ];
    }

    public function getLiveAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
