<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AutomationSchedule extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'automation_id', 'sender_id', 'subject', 'waiting_period',
        'waiting_type', 'utr', 'template_id', 'preview_img',
        'template_json', 'template_html'];

    protected $appends = ['design_url', 'image'];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function getDesignUrlAttribute()
    {
        if ($this->template_id) {
            return route('user.automationScheduleEmailDesign', $this->utr);
        }
        return route('user.automationScheduleEmailTemplate', $this->utr);
    }

    public function getImageAttribute()
    {
        return asset('assets/sample_template/' . ($this->preview_img ?? 'blank.png'));
    }

    public function sender()
    {
        return $this->belongsTo(Sender::class, 'sender_id')->withTrashed();
    }

    public function automation()
    {
        return $this->belongsTo(Automation::class, 'automation_id')->withTrashed();
    }

    public function recipients()
    {
        return $this->hasMany(EmailAutomationMap::class, 'automation_schedule_id');
    }

    public function template()
    {
        return $this->belongsTo(EmailTemplate::class, 'template_id')->withTrashed();
    }
}
