<?php

namespace App\Models;

use App\Traits\TimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contact extends Model
{
    use HasFactory, SoftDeletes, TimeZone;

    protected $fillable = ['user_id', 'contact_type_id', 'first_name', 'last_name', 'email', 'alt_email', 'country',
        'state', 'city', 'address_line1', 'address_line2', 'state_province_region', 'postal_code', 'custom_field'];

    protected $appends = ['fullname'];
    protected $casts = [
        'custom_field' => 'object'
    ];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function contactType()
    {
        return $this->belongsTo(ContactType::class, 'contact_type_id');
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function recipientData()
    {
        $contacts['first_name'] = $this->first_name;
        $contacts['last_name'] = $this->last_name;
        $contacts['email'] = $this->email;
        $contacts['alt_email'] = $this->alt_email;
        $contacts['country'] = $this->country;
        $contacts['state'] = $this->state;
        $contacts['city'] = $this->city;
        $contacts['address_line1'] = $this->address_line1;
        $contacts['address_line2'] = $this->address_line2;
        $contacts['state_province_region'] = $this->state_province_region;
        $contacts['postal_code'] = $this->postal_code;

        if ($this->custom_field) {
            foreach ($this->custom_field as $key => $field) {
                $contacts[$key] = $field->field_value;
            }
        }

        return $contacts;
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }

    public function getUpdatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
