<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContactType extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['user_id', 'name'];

    public function scopeOwn($query, $include = 0)
    {
        if ($include) {
            return $query->where('user_id', auth()->id())->orWhere('user_id', null);
        }
        return $query->where('user_id', auth()->id());
    }

    public function contacts()
    {
        return $this->hasMany(Contact::class, 'contact_type_id');
    }

    public function countGlobalContacts()
    {
        return Contact::where('user_id', auth()->id())->count();
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
