<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Segment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['user_id', 'contact_type_id', 'segment_name', 'select_field', 'select_operator', 'value', 'query_type'];

    protected $casts = [
        'select_field' => 'object',
        'select_operator' => 'object',
        'value' => 'object',
        'query_type' => 'object',
    ];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function segmentEmails()
    {
        return $this->hasMany(SegmentEmail::class, 'segment_id');
    }
}
