<?php

namespace App\Models;

use App\Traits\TimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnsubscribeClient extends Model
{
    use HasFactory, TimeZone;

    protected $fillable = ['user_id', 'unsubscribe_groups_id', 'email_address'];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function unsubscribeGroup()
    {
        return $this->belongsTo(UnsubscribeGroup::class, 'unsubscribe_groups_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }

    public function getUpdatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
