<?php

namespace App\Services;

use App\Models\CustomField;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Exception;

class SegmentService
{
    public function createSegment($request)
    {
        try {
            $selectFields = $request['select_field'] ?? [];
            $selectOperators = $request['select_operator'] ?? [];
            $values = $request['value'] ?? [];
            $queryTypes = $request['query_type'] ?? [];
            $operatorCross = config('segments');

            if ($request['segment_type'] == 'existing') {
                $query = DB::table('contacts')->where('contact_type_id', $request['contact_type_id'])->where('user_id', auth()->id())->whereNull('deleted_at');
            } else {
                $query = DB::table('contacts')->where('user_id', auth()->id())->whereNull('deleted_at');
            }

            $key = 0;
            if (count($selectFields) === count($selectOperators)) {
                for ($i = 0; $i < count($selectFields); $i++) {
                    $customField = CustomField::select(['id', 'field_name', 'field_type', 'is_reserved'])->find($selectFields[$i]);
                    if ($customField) {
                        $field = $customField->field_name;
                        $operator = $operatorCross[$selectOperators[$i]];
                        $value = $values[$key] ?? null;
                        $queryType = @$queryTypes[$i] ?? 'and';

                        $percentOperator = $this->getPercentOperator($selectOperators[$i]);

                        if ($customField->is_reserved) {
                            if ($queryType === 'and') {
                                $query->where($field, $operator, $percentOperator['left'] . $value . $percentOperator['right']);
                            } elseif ($queryType === 'or') {
                                $query->orWhere(function ($query) use ($field, $operator, $value, $percentOperator) {
                                    $query->where($field, $operator, $percentOperator['left'] . $value . $percentOperator['right']);
                                });
                            }
                        } else {
                            if ($queryType === 'and') {
                                if ($operator == 'BETWEEN' || $operator == 'NOT BETWEEN') {
                                    $value1 = $values[++$key];
                                    $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(custom_field, '$.{$field}.field_value')) {$operator} '{$value}' AND {$value1}");
                                } else {
                                    $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(custom_field, '$.{$field}.field_value')) {$operator} '{$value}'");
                                }
                            } elseif ($queryType === 'or') {
                                $query->orWhere(function ($query) use ($field, $operator, $value, $percentOperator) {
                                    $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(custom_field, '$.{$field}.field_value')) {$operator} '{$value}'");
                                });
                            }
                        }
                        $key++;
                    }
                }
            } else {
                // Handle the case where the arrays have different lengths
                // You can return an error response or take appropriate action
            }

            //$results = $query->toRawSql();
            $results = $query->get();

            return [
                'status' => 'success',
                'result' => $results,
            ];
        } catch (Exception $e) {
            return [
                'status' => 'error',
                'message' => $e->getMessage(),
            ];
        }
    }

    public function getPercentOperator($operator)
    {
        if ($operator == 'contains' || $operator == 'does not contain' || $operator == 'contains word') {
            return [
                'left' => '%',
                'right' => '%',
            ];
        }

        if ($operator == 'starts with' || $operator == 'does not start with') {
            return [
                'left' => null,
                'right' => '%',
            ];
        }

        if ($operator == 'ends with' || $operator == 'does not end with') {
            return [
                'left' => '%',
                'right' => null,
            ];
        }

        return [
            'left' => null,
            'right' => null,
        ];
    }
}
