<?php


namespace App\Traits;

use App\Mail\SendNotificationMail;
use App\Models\Automation;
use App\Models\AutomationSchedule;
use App\Models\Notification;
use App\Models\UserActivity;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

trait Activity
{
    protected $initiateDate = "";
    protected $initiateTime = "";

    public function emailNotification($message, $url = null, $urlName = null, $userId = null): void
    {
        $notifications = Notification::own($userId)->get();
        foreach ($notifications as $notification) {
            Mail::to($notification->email_address)->queue(new SendNotificationMail($message, $notification, $url, $urlName));
        }
    }

    public function automationTriggered($recipients, $table, $id, $userId = null): void
    {
        $automations = Automation::own($userId)->with(['automationSchedule', 'automationSchedule.sender'])
            ->where('automation_for_table', $table)
            ->where('automation_for', $id)->where('status', 1)->get();


        $emailAutomationMaps = [];
        if (count($recipients) > 0 && count($automations) > 0) {
            foreach ($recipients as $recipient) {
                $field_data = $recipient->recipientData();
                try {
                    foreach ($automations as $automation) {
                        try {
                            $isNewAutomation = true;
                            if (count($automation->automationSchedule) > 0) {
                                foreach ($automation->automationSchedule as $schedule) {
                                    try {
                                        $calDateTime = $this->calculateTriggerDate($schedule, $isNewAutomation);
                                        $emailAutomationMaps[] = [
                                            'user_id' => auth()->id(),
                                            'automation_id' => $automation->id,
                                            'automation_schedule_id' => $schedule->id,
                                            'sender_id' => $schedule->sender_id,
                                            'email_address' => $recipient->email,
                                            'field_data' => json_encode($field_data),
                                            'sender_address' => optional($schedule->sender)->from_email ?? null,
                                            'sender_name' => optional($schedule->sender)->from_name ?? null,
                                            'reply_to' => $schedule->sender->reply_to_email ?? null,
                                            'company_address' => $schedule->sender->company_address ?? null,
                                            'subject' => $schedule->subject,
                                            'template_html' => $schedule->template_html,
                                            'triggered_date' => $calDateTime['date'],
                                            'triggered_time' => $calDateTime['time'],
                                            'status' => 0,
                                            'created_at' => Carbon::now(),
                                            'updated_at' => Carbon::now(),
                                        ];
                                        $isNewAutomation = false;
                                    } catch (\Exception $e) {
                                        continue;
                                    }
                                }
                            }
                        } catch (\Exception $e) {
                            continue;
                        }
                    }
                } catch (\Exception $e) {
                    continue;
                }
            }
            if (!empty($emailAutomationMaps)) {
                DB::table('email_automation_maps')->insert($emailAutomationMaps);
            }
        }
    }

    public function calculateTriggerDate($schedule, $isNewAutomation)
    {
        if ($isNewAutomation) {
            $this->initiateDate = Carbon::now()->toDateString();
            $this->initiateTime = Carbon::now()->toTimeString();
        }

        if ($schedule->waiting_type == 'instantly') {
            $this->initiateDate = Carbon::parse($this->initiateDate)->toDateString();
            $this->initiateTime = Carbon::parse($this->initiateTime)->addMinutes(2)->toTimeString();
        } elseif ($schedule->waiting_type == 'days') {
            $this->initiateDate = Carbon::parse($this->initiateDate)->addDays($schedule->waiting_period)->toDateString();
            $this->initiateTime = Carbon::parse($this->initiateTime)->toTimeString();
        } elseif ($schedule->waiting_type == 'hours') {
            $this->initiateDate = Carbon::parse($this->initiateDate)->toDateString();
            $this->initiateTime = Carbon::parse($this->initiateTime)->addHours($schedule->waiting_period)->toTimeString();
        }

        return [
            'date' => $this->initiateDate,
            'time' => $this->initiateTime,
        ];
    }

    public function userActivity($text, $userId = null, $ip = null): void
    {
        UserActivity::create([
            'user_id' => $userId ?? auth()->id(),
            'text' => $text,
            'ip' => $ip
        ]);
    }
}
