<?php

namespace App\Traits;

use App\Models\ApiClient;
use App\Models\User;
use Carbon\Carbon;
use Stevebauman\Location\Facades\Location;

trait ApiValidation
{
    public $validationErrorStatus = 422;
    public $uncompletedErrorStatus = 423;
    public $unauthorizedErrorStatus = 403;
    public $notFoundErrorStatus = 404;
    public $invalidErrorStatus = 400;
    public $notAcceptableStatus = 406;
    public $unknownStatus = 419;

    public function validationErrors($error)
    {
        return ['message' => 'The given data was invalid.', 'error' => $error];
    }

    public function withErrors($error)
    {
        return ['status' => 'failed', 'errors' => $error];
    }

    public function withSuccess($msg)
    {
        return ['status' => 'success', 'message' => $msg];
    }

    public function user($publicKey, $secretKey, $ip = null)
    {
        $user = User::where('public_key', $publicKey)->where('secret_key', $secretKey)->first();
        if ($user->plan_id) {
            $runningPlan = $user->plan;
            if ($runningPlan && !$runningPlan->api_uses && $user->subs_expired_at > Carbon::now()) {
                return null;
            }
        }

        if ($ip) {
            $isUsed = \Cache::get('ip');
            if (!$isUsed) {
                $currentUserInfo = Location::get($ip);
                ApiClient::updateOrCreate(
                    ['ip' => $ip, 'user_id' => $user->id],
                    [
                        'country_name' => $currentUserInfo->countryName,
                        'country_code' => $currentUserInfo->countryCode,
                        'region_code' => $currentUserInfo->regionCode,
                        'region_name' => $currentUserInfo->regionName,
                        'city_name' => $currentUserInfo->cityName,
                        'zip_code' => $currentUserInfo->zipCode,
                        'latitude' => $currentUserInfo->latitude,
                        'longitude' => $currentUserInfo->longitude,
                    ]
                );
                \Cache::put('ip', $ip);
            }

            if (ApiClient::where('user_id', $user->id)->where('ip', $ip)->where('is_blocked', 1)->exists()) {
                return null;
            }
        }

        return $user;
    }
}
