<?php
return [
    'hero' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'short_description' => 'textarea',
                'button_name' => 'text',
                'my_link' => 'url',
                'clients_served' => 'text',
                'happy_clients' => 'text',
                'image' => 'file',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:500',
                'short_description.*' => 'required|max:1000',
                'button_name.*' => 'required|max:50',
                'clients_served.*' => 'required',
                'happy_clients.*' => 'required',
                'my_link.*' => 'required|url',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/hero.png',
    ],

    'features' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'description' => 'textarea',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
            ]
        ],
        'multiple' => [
            'field_name' => [
                'heading' => 'text',
                'short_description' => 'textarea',
            ],
            'validation' => [
                'heading.*' => 'required|max:100',
                'short_description.*' => 'required|max:5000',
            ]
        ],
        'preview' => 'assets/preview/features.png',
    ],

    'about' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'short_description' => 'textarea',
                'button_name' => 'text',
                'my_link' => 'url',
                'image' => 'file',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:500',
                'short_description.*' => 'required|max:1000',
                'button_name.*' => 'required|max:50',
                'my_link.*' => 'required|url',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/about.png',
    ],

    'pricing' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'short_description' => 'textarea',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:500',
                'short_description.*' => 'required|max:1000',
            ]
        ],
        'preview' => 'assets/preview/pricing.png',
    ],

    'testimonial' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'description' => 'textarea',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
            ]
        ],
        'multiple' => [
            'field_name' => [
                'name' => 'text',
                'address' => 'text',
                'short_description' => 'textarea',
                'image' => 'file',
            ],
            'validation' => [
                'name.*' => 'required|max:100',
                'address.*' => 'required|max:500',
                'short_description.*' => 'required|max:5000',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/testimonial.png',
    ],

    'how_it_works' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'description' => 'textarea',
                'button_name' => 'text',
                'my_link' => 'url',
                'image' => 'file',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
                'button_name.*' => 'required|max:50',
                'my_link.*' => 'required|url',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'multiple' => [
            'field_name' => [
                'heading' => 'text',
                'short_description' => 'textarea',
            ],
            'validation' => [
                'heading.*' => 'required|max:100',
                'short_description.*' => 'required|max:5000',
            ]
        ],
        'preview' => 'assets/preview/how_it_works.png',
    ],

    'faq' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'description' => 'textarea',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
            ]
        ],
        'multiple' => [
            'field_name' => [
                'heading' => 'text',
                'short_description' => 'textarea',
            ],
            'validation' => [
                'heading.*' => 'required|max:100',
                'short_description.*' => 'required|max:5000',
            ]
        ],
        'preview' => 'assets/preview/faq.png',
    ],

    'blog' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'heading' => 'text',
                'description' => 'textarea',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'heading.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
            ]
        ],
        'multiple' => [
            'field_name' => [
                'title' => 'text',
                'name' => 'text',
                'designation' => 'text',
                'description' => 'textarea',
                'person_image' => 'file',
                'image' => 'file',
            ],
            'validation' => [
                'title.*' => 'required|max:1000',
                'name.*' => 'required|max:1000',
                'designation.*' => 'required|max:1000',
                'description.*' => 'required|max:5000',
                'person_image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/blog.png',
    ],

    'documentation' => [
        'single' => [
            'field_name' => [
                'title' => 'text',
                'description' => 'textarea',
                'button_name' => 'text',
                'image' => 'file',
            ],
            'validation' => [
                'title.*' => 'required|max:100',
                'description.*' => 'required|max:5000',
                'button_name.*' => 'required|max:100',
                'image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/documentation.png',
    ],

    'contact' => [
        'single' => [
            'field_name' => [
                'phone' => 'text',
                'email' => 'text',
                'address' => 'text',
                'contact_message' => 'textarea',
                'drop_line_message' => 'textarea',
                'footer_message' => 'textarea',
                'subscriber_message' => 'textarea',
            ],
            'validation' => [
                'phone.*' => 'required|max:20',
                'email.*' => 'required|email',
                'address.*' => 'required|max:2000',
                'contact_message.*' => 'required|max:5000',
                'drop_line_message.*' => 'required|max:5000',
                'footer_message.*' => 'required|max:5000',
                'subscriber_message.*' => 'required|max:5000',
            ]
        ],
        'preview' => 'assets/preview/contact.png',
    ],

    'login-register' => [
        'single' => [
            'field_name' => [
                'login_heading' => 'text',
                'login_sub_heading' => 'text',
                'register_heading' => 'text',
                'register_sub_heading' => 'text',
                'login_page_image' => 'file',
                'register_page_image' => 'file',
                'verify_page_image' => 'file',
            ],
            'validation' => [
                'login_heading.*' => 'required|max:500',
                'login_sub_heading.*' => 'required|max:500',
                'register_heading.*' => 'required|max:500',
                'register_sub_heading.*' => 'required|max:500',
                'login_page_image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
                'register_page_image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
                'verify_page_image.*' => 'nullable|max:10240|image|mimes:jpg,jpeg,png',
            ]
        ],
        'preview' => 'assets/preview/login-register.png',
    ],

    'social' => [
        'multiple' => [
            'field_name' => [
                'name' => 'text',
                'icon' => 'icon',
                'my_link' => 'url',
            ],
            'validation' => [
                'name.*' => 'required|max:100',
                'icon.*' => 'required|max:100',
                'my_link.*' => 'required|url',
            ]
        ],
        'preview' => 'assets/preview/social.png',
    ],


    'message' => [
        'required' => 'This field is required.',
        'min' => 'This field must be at least :min characters.',
        'max' => 'This field may not be greater than :max characters.',
        'image' => 'This field must be image.',
        'mimes' => 'This image must be a file of type: jpg, jpeg, png.',
        'integer' => 'This field must be an integer value',
    ],

    'content_media' => [
        'image' => 'file',
        'thumb_image' => 'file',
        'person_image' => 'file',
        'login_page_image' => 'file',
        'register_page_image' => 'file',
        'verify_page_image' => 'file',
        'my_link' => 'url',
        'icon' => 'icon',
        'count_number' => 'number',
        'start_date' => 'date'
    ]
];

