<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('senders', function (Blueprint $table) {
            $table->id();
            $table->string('from_name')->nullable();
            $table->string('from_email')->nullable();
            $table->string('reply_to_email')->nullable();
            $table->foreignId('country')->index()->nullable();
            $table->foreignId('state')->index()->nullable();
            $table->foreignId('city')->index()->nullable();
            $table->string('zip_code')->nullable();
            $table->string('company_address')->nullable();
            $table->string('company_address2')->nullable();
            $table->string('nickname')->nullable();
            $table->boolean('is_verified')->default(0)->comment("0=>no verified, 1=> verified");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('senders');
    }
};
