<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('single_send_activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index();
            $table->foreignId('single_send_id')->index()->nullable();
            $table->string('email')->nullable();
            $table->tinyInteger('type')->default(1)->comment('1=>delivered,2=>bounces,3=>unique_opens,4=unsubscribe');
            $table->date('triggered_date')->nullable();
            $table->time('triggered_time');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('single_send_activities');
    }
};
