<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('automations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index();
            $table->foreignId('automation_for')->index()->comment('Would be contact type id or segment id');
            $table->string('automation_for_table')->nullable();
            $table->string('automation_name')->nullable();
            $table->tinyInteger('exit_criteria')->default(1)->comment("1=>in the automation,2=>no longer meet");
            $table->string('unsubscribe_group')->comment("0=> for global");
            $table->tinyInteger('automation_type')->nullable();
            $table->text('utr')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('automations');
    }
};
