<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('automation_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index();
            $table->foreignId('automation_id')->index();
            $table->foreignId('sender_id')->index()->nullable();
            $table->text('subject')->nullable();
            $table->integer('waiting_period')->nullable();
            $table->enum('waiting_type', ['instantly', 'days', 'hours'])->nullable();
            $table->date('triggered_date')->nullable();
            $table->date('triggered_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('automation_schedules');
    }
};
