<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('email_automation_maps', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index();
            $table->foreignId('automation_id')->index()->nullable();
            $table->foreignId('automation_schedule_id')->index()->nullable();
            $table->foreignId('sender_id')->index()->nullable();
            $table->string('email_address')->nullable();
            $table->string('sender_address')->nullable();
            $table->string('subject')->nullable();
            $table->longText('template_html')->nullable();
            $table->date('triggered_date')->nullable();
            $table->time('triggered_time')->nullable();
            $table->tinyInteger('status')->default(0)->comment("0=>initialize,1=>triggered,2=>fail");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_automation_maps');
    }
};
