<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        \Illuminate\Support\Facades\DB::statement("INSERT INTO `gateways` (`id`, `code`, `name`, `sort_by`, `image`, `driver`, `status`, `parameters`, `currencies`, `extra_parameters`, `supported_currency`, `receivable_currencies`, `description`, `currency_type`, `is_sandbox`, `environment`, `is_manual`, `note`, `is_subscription`, `subscription_on`, `created_at`, `updated_at`) VALUES
        (41, 'paddle', 'Paddle', 38, 'gateway/ctJGPni1AMRJAU5xNCDJVUbP5MgD8t.webp', 'local', 0, '{\"api_key\":\"your_key\",\"client_side_token\":\"your_token\"}', '{\"0\":{\r\n  \"USD\": \"USD\",\r\n  \"EUR\": \"EUR\",\r\n  \"GBP\": \"GBP\",\r\n  \"ARS\": \"ARS\",\r\n  \"AUD\": \"AUD\",\r\n  \"BRL\": \"BRL\",\r\n  \"CAD\": \"CAD\",\r\n  \"CNY\": \"CNY\",\r\n  \"COP\": \"COP\",\r\n  \"CZK\": \"CZK\",\r\n  \"DKK\": \"DKK\",\r\n  \"HKD\": \"HKD\",\r\n  \"HUF\": \"HUF\",\r\n  \"ILS\": \"ILS\",\r\n  \"INR\": \"INR\",\r\n  \"JPY\": \"JPY\",\r\n  \"KRW\": \"KRW\",\r\n  \"MXN\": \"MXN\",\r\n  \"NOK\": \"NOK\",\r\n  \"NZD\": \"NZD\",\r\n  \"DKK\": \"DKK\",\r\n  \"PLN\": \"PLN\",\r\n  \"RUB\": \"RUB\",\r\n  \"SEK\": \"SEK\",\r\n  \"SGD\": \"SGD\",\r\n  \"THB\": \"THB\",\r\n  \"TRY\": \"TRY\",\r\n  \"TWD\": \"TWD\",\r\n  \"UAH\": \"UAH\",\r\n  \"ZAR\": \"ZAR\"}}', '{\"default_payment_link\":\"ipn\",\"subscription_webhook_url\":\"subscription.ipn\"}', '[\"USD\",\"GBP\"]', '[{\"name\":\"USD\",\"currency_symbol\":\"USD\",\"conversion_rate\":\"1\",\"min_limit\":\"1\",\"max_limit\":\"10000\",\"percentage_charge\":\"0.5\",\"fixed_charge\":\"0.5\"},{\"name\":\"GBP\",\"currency_symbol\":\"GBP\",\"conversion_rate\":\"0.90\",\"min_limit\":\"1\",\"max_limit\":\"100\",\"percentage_charge\":\"1\",\"fixed_charge\":\"1\"}]', 'Send form your payment gateway. your bank may charge you a cash advance fee.', 1, 1, 'test', NULL, 'Paddle exclusively offers subscription-based support, with no provision for one-time payments in this regard.', 1, 1, '2020-09-10 09:05:02', '2024-02-06 07:21:17');");

        \Illuminate\Support\Facades\DB::statement("INSERT INTO `notification_templates` (`id`, `language_id`, `name`, `template_key`, `email_from`, `subject`, `short_keys`, `email`, `sms`, `in_app`, `push`, `status`, `notify_for`, `lang_code`, `created_at`, `updated_at`) VALUES (23, '1', 'Reset Password Notification', 'PASSWORD_RESET', 'support@you.com', 'Reset Password Notification', '{\"message\":\"message\"}', 'You are receiving this email because we received a password reset request for your account.[[message]]\r\n\r\n\r\nThis password reset link will expire in 60 minutes.\r\n\r\nIf you did not request a password reset, no further action is required.', 'You are receiving this email because we received a password reset request for your account. [[message]]', NULL, NULL, '{\"mail\":\"1\",\"sms\":\"1\",\"in_app\":\"0\",\"push\":\"0\"}', '0', 'en', '2021-08-03 00:05:43', '2024-01-21 16:40:05');");

        Schema::table('basic_controls', function (Blueprint $table) {
            $table->integer('emailThrottleTime')->nullable();
            $table->boolean('emailThrottleStatus')->default(0);
            $table->integer('email_check_max_limit')->default(100)->comment("how many email check validation in one time	");
            $table->integer('credit_bonus')->default(0);
        });

        Schema::table('users', function (Blueprint $table) {
            $table->integer('credits')->nullable()->comment("email verification credits");
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('basic_controls', function (Blueprint $table) {
            $table->dropColumn('emailThrottleTime');
            $table->dropColumn('emailThrottleStatus');
            $table->dropColumn('email_check_max_limit');
            $table->dropColumn('credit_bonus');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('credits');
        });
    }
};
