@extends('admin.layouts.app')
@section('page_title',__('Automation Details'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Automation')</a></li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('page_title')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@yield('page_title')</h1>
                </div>
            </div>
        </div>

        <div class="content container-fluid">
            <div class="row justify-content-lg-center">
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-grid gap-3 gap-lg-5">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between">
                                        <h4 class="card-title mt-2">@lang("Automation Details")</h4>
                                    </div>
                                    <div class="card-body mt-2">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Name of the Automation')</label>
                                                <input type="text" class="form-control"
                                                       value="{{$automation->automation_name}}"
                                                       id="subjectLabel" aria-label="@lang('Name of the Automation')"
                                                       autocomplete="off">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Unsubscribe Group')</label>
                                                <input type="text" class="form-control"
                                                       value="{{optional($automation->unsubscribeGroup)->group_name}}"
                                                       id="subjectLabel" aria-label="@lang('Unsubscribe Group')"
                                                       autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="email-card-container mt-30" id="emailShow">
                                            @if($automation->automationSchedule)
                                                @foreach($automation->automationSchedule as $key => $schedule)
                                                    <div class="item">
                                                        <div class="d-flex justify-content-center">
                                                            <a href="javascript:void(0)"
                                                               class="email-card-secondary-btn editPeriodBtn">{{$schedule->waiting_type == 'instantly' ? 'Send email instantly' : 'Wait '. $schedule->waiting_period.' ' .$schedule->waiting_type}}
                                                                <i
                                                                    class="fa-regular fa-pen"></i></a>
                                                        </div>

                                                        <div class="email-card ">
                                                            <div class="row align-items-center">
                                                                <div class="col-md-1">
                                                                    <div class="email-count">EMAIL {{++$key}}</div>
                                                                </div>
                                                                <div class="col-md-2">
                                                                    <div class="email-card-thumbs-area">
                                                                        <img
                                                                            src="{{$schedule->image}}"
                                                                            alt="...">
                                                                        <div class="email-card-btn-area">
                                                                            <a href="javascript:void(0)"
                                                                               class="cmn-btn"><i
                                                                                    class="fa-regular fa-circle-plus"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-2 text-center text-md-start">
                                                                    <h6>@lang('Subject')</h6>
                                                                    <h6>@lang('From Sender')</h6>
                                                                </div>
                                                                <div
                                                                    class="col-md-2 flex-grow-1 text-center text-md-start">
                                                                    <div class="d-flex flex-column g-3">
                                                                        <a href="javascript:void(0)"
                                                                           class="link selectSender">{{$schedule->subject}}</a>
                                                                        <a href="javascript:void(0)"
                                                                           class="link selectSender">{{optional($schedule->sender)->from_email}}</a>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection










