<div class="row mb-2">
    <div class="col-md-6" id="automationPerformance">
        <div class="card mt-50">
            <div class="card-header d-flex justify-content-between border-0">
                <h4>@lang('Automation Performance')</h4>
            </div>
            <div class="card-body">
                <div id="chart"></div>
            </div>
        </div>
    </div>
    <div class="col-md-6" id="singleSendPerformance">
        <div class="card mt-50">
            <div class="card-header d-flex justify-content-between border-0">
                <h4>@lang('Single Send Performance')</h4>
            </div>
            <div class="card-body">
                <div id="chart1"></div>
            </div>
        </div>
    </div>
</div>


@push('script')
    <script>
        Notiflix.Block.standard('#automationPerformance');
        var options = {
            series: [{
                data: [],
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: ['Triggered', 'Delivered', 'Bounces', 'Unique Opens', 'Total Open', 'Unsubscribe'
                ],
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            yaxis: {
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            colors: ['#6e71ff'],
        };
        updateAutomationPerformanceGraph();

        async function updateAutomationPerformanceGraph() {
            let $url = "{{ route('admin.chartAutomationPerformance') }}"
            await axios.get($url)
                .then(function (res) {

                    options.series[0].data = res.data.automationPerformance.horizontalBarChatAutomation;
        
                    var chart = new ApexCharts(document.querySelector("#chart"), options);
                    chart.render();
                    Notiflix.Block.remove('#automationPerformance');
                })
                .catch(function (error) {
                });
        }
    </script>

    <script>
        Notiflix.Block.standard('#singleSendPerformance');
        var options1 = {
            series: [{
                data: [],
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: ['Triggered', 'Delivered', 'Bounces', 'Unique Opens', 'Total Open', 'Unsubscribe'
                ],
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            yaxis: {
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            colors: ['#6e71ff'],
        };

        updateSingleSendPerformanceGraph();

        async function updateSingleSendPerformanceGraph() {
            let $url = "{{ route('admin.chartSingleSendPerformance') }}"
            await axios.get($url)
                .then(function (res) {

                    options1.series[0].data = res.data.singleSendPerformance.horizontalBarChatSingleSend;
                    var chart1 = new ApexCharts(document.querySelector("#chart1"), options1);
                    chart1.render();
                    Notiflix.Block.remove('#singleSendPerformance');
                })
                .catch(function (error) {
                });
        }

    </script>
@endpush
