@extends('admin.layouts.app')
@section('page_title',__('Single Send Statistics'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Single Send')</a></li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('page_title')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@yield('page_title')</h1>
                </div>
            </div>
        </div>
        <div class="content container-fluid">
            <div class="row justify-content-lg-center">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="d-grid gap-3 gap-lg-5">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between">
                                        <h4 class="card-title mt-2">@lang("Single Send Statistics")</h4>
                                    </div>
                                    <div class="card-body mt-2">
                                        <div class="col-12 d-none d-lg-block">
                                            <div class="row g-4">
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("TRIGGERED")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->triggered??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("DELIVERED")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->delivered??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("BOUNCES")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->bounces??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("UNIQUE OPENS")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->unique_opens??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("TOTAL OPENS")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->total_opens??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-lg-2 mb-3 mb-lg-5">
                                                    <div class="card h-100">
                                                        <div class="card-body">
                                                            <h6 class="card-subtitle mb-2">@lang("UNSUBSCRIBE")</h6>
                                                            <div class="row align-items-center gx-2">
                                                                <div class="col">
                                                            <span
                                                                class="js-counter display-4 text-dark">{{$singleSend->unsubscribes??0}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <div class="card mt-50">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <h5>@lang('Delivered Rate')</h5>
                                                                    <h5>{{$deliveredPercent}} %</h5>
                                                                </div>
                                                                <div class="progress">
                                                                    <div class="progress-bar bg-success"
                                                                         role="progressbar"
                                                                         style="width: {{$deliveredPercent}}%"
                                                                         aria-valuenow="{{$deliveredPercent}}"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <ul class="mt-3">
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Total Triggered')</p>
                                                                        <span>{{$singleSend->triggered??0}}</span>
                                                                    </li>
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Successful Deliveries')</p>
                                                                        <span>{{$singleSend->delivered??0}}</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="card mt-50">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <h5>@lang('Bounces Rate')</h5>
                                                                    <h5>{{$bouncesPercent}} %</h5>
                                                                </div>
                                                                <div class="progress">
                                                                    <div class="progress-bar bg-danger"
                                                                         role="progressbar"
                                                                         style="width: {{$bouncesPercent}}%"
                                                                         aria-valuenow="{{$bouncesPercent}}"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <ul class="mt-3">
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Total Triggered')</p>
                                                                        <span>{{$singleSend->triggered??0}}</span>
                                                                    </li>
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Bounces')</p>
                                                                        <span>{{$singleSend->bounces??0}}</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="card mt-50">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <h5>@lang('Unique Opens')</h5>
                                                                    <h5>{{$uniqueOpenPercent}} %</h5>
                                                                </div>
                                                                <div class="progress">
                                                                    <div class="progress-bar bg-primary"
                                                                         role="progressbar"
                                                                         style="width: {{$uniqueOpenPercent}}%"
                                                                         aria-valuenow="{{$uniqueOpenPercent}}"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <ul class="mt-3">
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Total Delivered')</p>
                                                                        <span>{{$singleSend->delivered??0}}</span>
                                                                    </li>
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Unique Opens')</p>
                                                                        <span>{{$singleSend->unique_opens??0}}</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="card mt-50">
                                                            <div class="card-body">
                                                                <div class="d-flex justify-content-between">
                                                                    <h5>@lang('Unsubscribes')</h5>
                                                                    <h5>{{$unsubscribesPercent}} %</h5>
                                                                </div>
                                                                <div class="progress">
                                                                    <div class="progress-bar bg-warning"
                                                                         role="progressbar"
                                                                         style="width: {{$unsubscribesPercent}}%"
                                                                         aria-valuenow="{{$unsubscribesPercent}}"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <ul class="mt-3">
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Total Delivered')</p>
                                                                        <span>{{$singleSend->delivered??0}}</span>
                                                                    </li>
                                                                    <li class="d-flex justify-content-between">
                                                                        <p>@lang('Unsubscribes')</p>
                                                                        <span>{{$singleSend->unsubscribes??0}}</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card mt-50">
                                                    <div class="card-header d-flex justify-content-between border-0">
                                                        <h4>@lang('Single Send Performance')</h4>
                                                    </div>
                                                    <div class="card-body">
                                                        <div id="chart"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <div class="card mt-50">
                                                    <div class="card-body">
                                                        <div id="chart2"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <div class="card mt-50">
                                                    <div class="card-body">
                                                        <div class="d-flex justify-content-between">
                                                            <h5 class="card-title">@lang('Unique Open VS Unsubscribe')</h5>
                                                            <input type="button" class="btn btn-white btn-sm"
                                                                   name="daterange"
                                                                   value=""/>
                                                        </div>
                                                        <canvas id="chart7" height="80"></canvas>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('css-lib')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/global/css/daterangepicker.css') }}"/>
@endpush

@push('js-lib')
    <script src="{{ asset('assets/global/js/Chart.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/global/js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/global/js/daterangepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/apexcharts.min.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            $('input[name="daterange"]').daterangepicker({
                opens: 'left',
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                locale: {
                    format: 'MMMM D, YYYY'
                }
            }, function (start, end, label) {
                getActivity(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            });

            function getActivity(start, end) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('admin.singleSendGetChart',$singleSend->utr) }}",
                    dataType: "json",
                    data: {
                        'start': start,
                        'end': end,
                    }
                })
                    .done(function (response) {
                        new Chart(document.getElementById("chart7"), {
                            type: 'line',
                            data: {
                                labels: response.labels,
                                datasets: [

                                    {
                                        data: response.dataUnique,
                                        label: "Unique Open",
                                        borderColor: "#6e71ff",
                                        fill: false
                                    },

                                    {
                                        data: response.dataUnsubscribe,
                                        label: "Unsubscribe",
                                        borderColor: "#dc3545",
                                        fill: false
                                    },
                                ]
                            }
                        });
                    });
            }
        });
        //Chart 1
        var options = {
            series: [{
                data: {!! json_encode($horizontalBarChat) !!},
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: ['Triggered', 'Delivered', 'Bounces', 'Unique Opens', 'Total Open', 'Unsubscribe'
                ],
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            yaxis: {
                labels: {
                    style: {
                        colors: '#7d8791'
                    }
                }
            },
            colors: ['#6e71ff'],
        };

        var chart = new ApexCharts(document.querySelector("#chart"), options);
        chart.render();

        //Chart 2
        var options2 = {
            series: [{
                name: 'XYZ MOTORS',
                data: {!! json_encode($lineChartUniqueOpen) !!}
            }],
            chart: {
                type: 'area',
                stacked: false,
                height: 350,
                zoom: {
                    type: 'x',
                    enabled: true,
                    autoScaleYaxis: true
                },
                toolbar: {
                    autoSelected: 'zoom'
                }
            },
            dataLabels: {
                enabled: false
            },
            markers: {
                size: 0,
            },
            title: {
                text: 'Unique Open Movement',
                align: 'left',
                style: {
                    color: '#7d8791' // Set the color for the chart title
                }
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    inverseColors: false,
                    opacityFrom: 0.5,
                    opacityTo: 0,
                    stops: [0, 90, 100]
                },
            },
            yaxis: {
                labels: {
                    formatter: function (val) {
                        //return (val / 1000000).toFixed(0);
                        return (val / 1).toFixed(0);
                    },
                    style: {
                        color: '#7d8791' // Set the color for y-axis title
                    }
                },
                title: {
                    text: 'Open',
                    style: {
                        color: '#7d8791' // Set the color for y-axis title
                    }
                },
            },
            xaxis: {
                type: 'datetime',
                labels: {
                    style: {
                        colors: '#7d8791' // Set the color for x-axis labels
                    }
                }
            },
            tooltip: {
                shared: false,
                y: {
                    formatter: function (val) {
                        return (val / 1000000).toFixed(0)
                    }
                }
            }
        };

        var chart2 = new ApexCharts(document.querySelector("#chart2"), options2);
        chart2.render();

        //Chart 7
        new Chart(document.getElementById("chart7"), {
            type: 'line',
            data: {
                labels: {!! json_encode($labels) !!},
                datasets: [

                    {
                        data: {!! json_encode($dataUnique) !!},
                        label: "Unique Open",
                        borderColor: "#6e71ff",
                        fill: false
                    },

                    {
                        data: {!! json_encode($dataUnsubscribe) !!},
                        label: "Unsubscribe",
                        borderColor: "#dc3545",
                        fill: false
                    },
                ]
            },
            options: {
                scales: {
                    xAxes: [{
                        ticks: {
                            fontColor: '#7d8791' // Set the color for x-axis labels
                        },
                    }],
                    yAxes: [{
                        ticks: {
                            fontColor: '#7d8791' // Set the color for y-axis labels
                        },
                    }],
                },
            },
        });
    </script>
@endpush










