@extends($theme . 'layouts.app')
@section('title',trans('BLog Details'))
@section('content')
    <!-- Blog details section start -->
    <section class="blog-details-section">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-7 order-2 order-lg-1">
                    <div class="blog-details">
                        <div class="thum-inner">
                            <div class="blog-image">
                                <img
                                    src="{{getFile(@$blogDetails->content->media->image->driver,@$blogDetails->content->media->image->path)}}"
                                    alt="...">
                            </div>
                        </div>
                        <div class="blog-author">
                            <div class="author-img">
                                <img
                                    src="{{getFile(@$blogDetails->content->media->person_image->driver,@$blogDetails->content->media->person_image->path)}}"
                                    alt="...">
                            </div>
                            <div class="author-info">
                                <a href="#">
                                    <h5>{{@$blogDetails->description->name}}</h5>
                                </a>
                                <span>{{@$blogDetails->description->designation}}</span>
                            </div>
                        </div>
                        <div class="blog-header">
                            <h3 class="">{{@$blogDetails->description->title}}</h3>
                        </div>
                        <div class="blog-para">
                            {!! @$blogDetails->description->description !!}
                        </div>
                    </div>

                </div>
                <div class="col-lg-5 order-1 order-lg-2">
                    <div class="blog-sidebar position-sticky">
                        <form action="{{route('blog.details')}}" method="get">
                            <input type="hidden" name="id" value="{{$blogDetails->id}}">
                            <input type="hidden" name="slug" value="{{slug($blogDetails->title)}}">
                            <div class="input-group-search d-flex align-items-center">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="title" value="{{@request()->title}}"
                                           placeholder="@lang('Search Here')..."
                                           aria-label="Username" aria-describedby="basic-addon1">
                                    <button type="submit" class="input-group-text hover" id="basic-addon1"><i
                                            class="far fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                        @if (isset($popularContentDetails['blog']))
                            <div class="section-header">
                                <h4>@lang('Recent Post')</h4>
                            </div>
                            <div class="blog-widget-area">
                                @foreach ($popularContentDetails['blog']->sortDesc() as $data)
                                    <a href="{{route('blog.details').'?id='.$data->id.'&slug='.slug($data->description->title)}}"
                                       class="blog-widget-item">
                                        <div class="blog-widget-image">
                                            <img
                                                src="{{getFile(@$data->content->media->image->driver,@$data->content->media->image->path)}}"
                                                alt="...">
                                        </div>
                                        <div class="blog-widget-content">
                                            <div class="blog-title">{{$data->description->title}}</div>
                                            <div class="blog-date">
                                                <div
                                                    class="blog-item1">{{dateTime($data->created_at,basicControl()->date_time_format)}}</div>
                                            </div>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog details Section End -->
@endsection
