@extends($theme . 'layouts.docx')
@section('title',trans('Authentication'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $siteTitle = basicControl()->site_title
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div class="row">
                            <div class="col-12 mb-4">
                                <h4>@lang('#Introduction')</h4>
                                <p>
                                    @lang("The $siteTitle API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies,
                                            returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs")
                                </p>
                                <p>
                                    @lang("The $siteTitle API doesn't support export csv. we can give you data you need to implement your own function to export.")
                                </p>
                            </div>
                            <div class="col-12 mb-4">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <h5>@lang('API Protocols')</h5>
                                        <p>@lang("Our APIs follow the general principles of REST")</p>
                                        <ol>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("1. We use standard <code>GET, POST, PUT, DELETE</code> requests to communicate and HTTP response codes to show status and errors.")
                                            </li>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("2. You can expect all responses to be returned as JSON.")
                                            </li>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("3. The API request should have a Content-Type of application/json.")
                                            </li>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("4. All endpoints require authentication with your API Keys.")
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 mb-4">
                                <h3>@lang('#Authentication')</h3>
                                <div class="card mb-4">
                                    <div class="card-body">

                                        <h5>@lang('Retrieving your API Keys')</h5>
                                        <p>@lang("Your API keys are very vital to making requests successfully to our servers. To get your keys follow the instruction")</p>
                                        <ol>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("1. Log into your $siteTitle dashboard.")
                                            </li>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("2. Click Api Key from sidebar.")
                                            </li>
                                            <li class="mb-1 text-dark font-weight-bold">
                                                @lang("3. Select the API Keys open in the Api Key section of the menu to view and copy your keys.")
                                            </li>
                                        </ol>
                                    </div>
                                </div>

                                <div>
                                    <h5>@lang('Authorizing API calls')</h5>
                                    <p>@lang("All API calls on $siteTitle are authenticated. API requests made without authorization will fail with the status : failed.")</p>
                                    <P>@lang("To authorize API calls from your server, pass your <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> as a header of api request. This means passing an Authorization header with a value of PublicKey: <code>YOUR_PUBLIC_KEY</code> and SecretKey: <code>YOUR_SECRET_KEY</code>")</P>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @include($theme.'partials.footer')

    </main>
@endsection
