@extends($theme . 'layouts.docx')
@section('title',trans('Unsubscribe Group'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $baseUrl = url('/').'/api/'
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div id="groupList" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Unsubscribe Group List')</h4>
                                <p>
                                    @lang("To get the Unsubscribe Group list follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}unsubscribes-groups</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl" type="button" role="tab"
                                                                aria-controls="cUrl" aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab" data-bs-toggle="pill"
                                                                data-bs-target="#PHP" type="button" role="tab"
                                                                aria-controls="PHP" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby" type="button" role="tab"
                                                                aria-controls="Ruby" aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js"
                                                                type="button" role="tab" aria-controls="Node-js"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Python" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js" role="tabpanel"
                                                     aria-labelledby="Node-js-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/unsubscribes-groups',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python" role="tabpanel"
                                                     aria-labelledby="Python-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP" role="tabpanel"
                                                     aria-labelledby="PHP-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                                     aria-labelledby="cUrl-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/unsubscribes-groups' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby" role="tabpanel"
                                                     aria-labelledby="Ruby-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab"
                                                                data-bs-toggle="pill" data-bs-target="#OK" type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request"
                                                                type="button" role="tab" aria-controls="Bad-Request"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK" role="tabpanel"
                                                     aria-labelledby="OK-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "unsubscribesGroups": [
            {
                "id": 5,
                "user_id": 6790,
                "rand_id": "54236",
                "group_name": "Betting Script",
                "description": "This is type of betting script you know what",
                "is_display": 1,
                "created_at": "2023-11-04T11:01:16.000000Z",
                "updated_at": "2023-11-04T12:03:09.000000Z",
                "unsubscribe_clients_count": 3
            },
            {
                "id": 4,
                "user_id": 6790,
                "rand_id": "65898",
                "group_name": "Investment",
                "description": "This is investment type script",
                "is_display": 0,
                "created_at": "2023-11-04T10:59:58.000000Z",
                "updated_at": "2023-11-04T10:59:58.000000Z",
                "unsubscribe_clients_count": 0
            },
            {
                "id": 3,
                "user_id": 6790,
                "rand_id": "17754",
                "group_name": "SASS Script",
                "description": "Ask AI any question you want and it will give an answer in seconds",
                "is_display": 1,
                "created_at": "2023-11-04T10:57:28.000000Z",
                "updated_at": "2023-11-04T10:57:28.000000Z",
                "unsubscribe_clients_count": 4
            }
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                        <div id="groupCreate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Unsubscribe Group Create')</h4>
                                <p>
                                    @lang("To create the Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}unsubscribes-groups/save</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>group_name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Group name what you want to name of the group. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="US Client">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>description<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">textarea</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Group description help you to remember why group create. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Description here">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>is_display<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">boolean</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    If you want this group on your unsubscribe preferences page. e.g.
                                                    not
                                                    display = 0, display =1 </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="1">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab2"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl2" type="button" role="tab"
                                                                aria-controls="cUrl2"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#PHP2" type="button" role="tab"
                                                                aria-controls="PHP2" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby2" type="button" role="tab"
                                                                aria-controls="Ruby2"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js2"
                                                                type="button" role="tab" aria-controls="Node-js2"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Python2" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js2" role="tabpanel"
                                                     aria-labelledby="Node-js-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/unsubscribes-groups/save',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'group_name': 'Example Group',
    'description': 'Description here',
    'is_display': '1'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python2" role="tabpanel"
                                                     aria-labelledby="Python-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/save"

payload={'group_name': 'Example Group',
'description': 'Description here',
'is_display': '1'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP2" role="tabpanel"
                                                     aria-labelledby="PHP-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/save',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('group_name' => 'Example Group','description' => 'Description here','is_display' => '1'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl2" role="tabpanel"
                                                     aria-labelledby="cUrl-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/unsubscribes-groups/save' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'group_name="Example Group"' \
--form 'description="Description here"' \
--form 'is_display="1"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby2" role="tabpanel"
                                                     aria-labelledby="Ruby-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/save")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['group_name', 'Example Group'],['description', 'Description here'],['is_display', '1']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#OK2"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request2"
                                                                type="button" role="tab" aria-controls="Bad-Request2"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK2" role="tabpanel"
                                                     aria-labelledby="OK-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Saved Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request2" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "group_name": [
            "The group name field is required."
        ],
        "description": [
            "The description field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="groupDetails" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Unsubscribe Group Details')</h4>
                                <p>
                                    @lang("To view the details of Unsubscribe group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}unsubscribes-groups/details?id={id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl3" type="button" role="tab"
                                                                aria-controls="cUrl3"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab3" data-bs-toggle="pill"
                                                                data-bs-target="#PHP3" type="button" role="tab"
                                                                aria-controls="PHP3"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby3" type="button" role="tab"
                                                                aria-controls="Ruby3"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js3"
                                                                type="button" role="tab" aria-controls="Node-js3"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python3" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js3" role="tabpanel"
                                                     aria-labelledby="Node-js-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/unsubscribes-groups/details?id=5',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python3" role="tabpanel"
                                                     aria-labelledby="Python-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/details?id=5"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP3" role="tabpanel"
                                                     aria-labelledby="PHP-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/details?id=5',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl3" role="tabpanel"
                                                     aria-labelledby="cUrl-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/unsubscribes-groups/details?id=5' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby3" role="tabpanel"
                                                     aria-labelledby="Ruby-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/details?id=5")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#OK3"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request3"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK3" role="tabpanel"
                                                     aria-labelledby="OK-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "unsubscribesGroup": {
            "id": 5,
            "user_id": 6790,
            "rand_id": "54236",
            "group_name": "Betting Script",
            "description": "This is type of betting script you know what",
            "is_display": 1,
            "created_at": "2023-11-04T11:01:16.000000Z",
            "updated_at": "2023-11-04T12:03:09.000000Z"
        }
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request3" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="groupUpdate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Unsubscribe Group Update')</h4>
                                <p>
                                    @lang("To update Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}unsubscribes-groups/update?id={id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>group_name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Group name what you want to name of the group. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="US Client">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>description<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">textarea</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Group description help you to remember why group
                                                    create. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Description here">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>is_display<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">boolean</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    If you want this group on your unsubscribe preferences page.
                                                    e.g.
                                                    not
                                                    display = 0, display =1 </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="1">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl4" type="button" role="tab"
                                                                aria-controls="cUrl4"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab4" data-bs-toggle="pill"
                                                                data-bs-target="#PHP4" type="button" role="tab"
                                                                aria-controls="PHP4"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby4" type="button" role="tab"
                                                                aria-controls="Ruby4"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js4"
                                                                type="button" role="tab" aria-controls="Node-js4"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python4" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js4" role="tabpanel"
                                                     aria-labelledby="Node-js-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/unsubscribes-groups/update?id=5',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'group_name': 'Hyip Script',
    'description': 'This is investment type script',
    'is_display': '1'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python4" role="tabpanel"
                                                     aria-labelledby="Python-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/update?id=5"

payload={'group_name': 'Hyip Script',
'description': 'This is investment type script',
'is_display': '1'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP4" role="tabpanel"
                                                     aria-labelledby="PHP-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/update?id=5',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('group_name' => 'Hyip Script','description' => 'This is investment type script','is_display' => '1'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl4" role="tabpanel"
                                                     aria-labelledby="cUrl-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/unsubscribes-groups/update?id=5' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'group_name="Hyip Script"' \
--form 'description="This is investment type script"' \
--form 'is_display="1"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby4" role="tabpanel"
                                                     aria-labelledby="Ruby-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/update?id=5")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['group_name', 'Hyip Script'],['description', 'This is investment type script'],['is_display', '1']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#OK4"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request4"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK4" role="tabpanel"
                                                     aria-labelledby="OK-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Updated Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request4" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "group_name": [
            "The group name field is required."
        ],
        "description": [
            "The description field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="groupRecipientsAdd" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Recipient Add')</h4>
                                <p>
                                    @lang("To recipient add in Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}unsubscribes-groups/manually-add</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>unsubscribe_groups_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Unsubscribe Group Id which group you want to add
                                                    recipients. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="5">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>email_address<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The list of email address must be comma separated. eg.
                                                    abc@gmail,xyz@gmail.com </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control"
                                                       value="abc@gmail,xyz@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl5" type="button" role="tab"
                                                                aria-controls="cUrl5"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab5" data-bs-toggle="pill"
                                                                data-bs-target="#PHP5" type="button" role="tab"
                                                                aria-controls="PHP5"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby5" type="button" role="tab"
                                                                aria-controls="Ruby5"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js5"
                                                                type="button" role="tab" aria-controls="Node-js5"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python5" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js5" role="tabpanel"
                                                     aria-labelledby="Node-js-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/unsubscribes-groups/manually-add',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'unsubscribe_groups_id': '5',
    'email_address': 'abc@gmail.com,xyz@gmail.com'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python5" role="tabpanel"
                                                     aria-labelledby="Python-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/manually-add"

payload={'unsubscribe_groups_id': '5',
'email_address': 'abc@gmail.com,xyz@gmail.com'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP5" role="tabpanel"
                                                     aria-labelledby="PHP-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/manually-add',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('unsubscribe_groups_id' => '5','email_address' => 'abc@gmail.com,xyz@gmail.com'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl5" role="tabpanel"
                                                     aria-labelledby="cUrl-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/unsubscribes-groups/manually-add' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'unsubscribe_groups_id="5"' \
--form 'email_address="abc@gmail.com,xyz@gmail.com"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby5" role="tabpanel"
                                                     aria-labelledby="Ruby-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/manually-add")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['unsubscribe_groups_id', '5'],['email_address', 'abc@gmail.com,xyz@gmail.com']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#OK5"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request5"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request5"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK5" role="tabpanel"
                                                     aria-labelledby="OK-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Added Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request5" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "email_address": [
            "The email address field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="groupRecipientsList" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Recipients List')</h4>
                                <p>
                                    @lang("To get recipient list in Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">
                                        {{$baseUrl}}unsubscribes-groups/recipients-list?groupId={groupId}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl6" type="button" role="tab"
                                                                aria-controls="cUrl6"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab6" data-bs-toggle="pill"
                                                                data-bs-target="#PHP6" type="button" role="tab"
                                                                aria-controls="PHP6"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby6" type="button" role="tab"
                                                                aria-controls="Ruby6"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js6"
                                                                type="button" role="tab" aria-controls="Node-js6"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python6" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js6" role="tabpanel"
                                                     aria-labelledby="Node-js-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/unsubscribes-groups/recipients-list?groupId=5',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python6" role="tabpanel"
                                                     aria-labelledby="Python-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/recipients-list?groupId=5"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP6" role="tabpanel"
                                                     aria-labelledby="PHP-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/recipients-list?groupId=5',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl6" role="tabpanel"
                                                     aria-labelledby="cUrl-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/unsubscribes-groups/recipients-list?groupId=5' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby6" role="tabpanel"
                                                     aria-labelledby="Ruby-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/recipients-list?groupId=5")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#OK6"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request6"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request6"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK6" role="tabpanel"
                                                     aria-labelledby="OK-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "recipients": [
            {
                "id": 49,
                "user_id": 6790,
                "unsubscribe_groups_id": 5,
                "email_address": "xyz@gmail.com",
                "created_at": "2023-12-02T05:03:34.000000Z",
                "updated_at": "2023-12-02T05:03:34.000000Z"
            },
            {
                "id": 48,
                "user_id": 6790,
                "unsubscribe_groups_id": 5,
                "email_address": "abc@gmail.com",
                "created_at": "2023-12-02T05:03:34.000000Z",
                "updated_at": "2023-12-02T05:03:34.000000Z"
            },
            {
                "id": 17,
                "user_id": 6790,
                "unsubscribe_groups_id": 5,
                "email_address": "alex@gmail.com",
                "created_at": "2023-11-05T05:34:36.000000Z",
                "updated_at": "2023-11-05T05:34:36.000000Z"
            },
            {
                "id": 16,
                "user_id": 6790,
                "unsubscribe_groups_id": 5,
                "email_address": "hasan@gmail.com",
                "created_at": "2023-11-05T05:34:36.000000Z",
                "updated_at": "2023-11-05T05:34:36.000000Z"
            },
            {
                "id": 13,
                "user_id": 6790,
                "unsubscribe_groups_id": 5,
                "email_address": "sunu@gmail.com",
                "created_at": "2023-11-05T05:31:59.000000Z",
                "updated_at": "2023-11-05T05:31:59.000000Z"
            }
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request6" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="groupRecipientsDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Recipients Delete')</h4>
                                <p>
                                    @lang("To delete recipient from Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">
                                        {{$baseUrl}}unsubscribes-groups/recipients-delete?id={id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl7" type="button" role="tab"
                                                                aria-controls="cUrl7"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#PHP7" type="button" role="tab"
                                                                aria-controls="PHP7"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby7" type="button" role="tab"
                                                                aria-controls="Ruby7"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js7"
                                                                type="button" role="tab" aria-controls="Node-js7"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python7" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js7" role="tabpanel"
                                                     aria-labelledby="Node-js-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/unsubscribes-groups/recipients-delete?id=10',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {

  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python7" role="tabpanel"
                                                     aria-labelledby="Python-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/recipients-delete?id=10"

payload={}
files={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP7" role="tabpanel"
                                                     aria-labelledby="PHP-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/recipients-delete?id=10',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl7" role="tabpanel"
                                                     aria-labelledby="cUrl-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/unsubscribes-groups/recipients-delete?id=10' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby7" role="tabpanel"
                                                     aria-labelledby="Ruby-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/recipients-delete?id=10")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = []
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#OK7"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request7"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request7"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK7" role="tabpanel"
                                                     aria-labelledby="OK-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request7" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="groupRecipientsBulkDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Recipients Bulk Delete')</h4>
                                <p>
                                    @lang("To bulk delete recipient from Unsubscribe Group follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}
                                        unsubscribes-groups/recipients-bulk-delete</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>strIds<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">array</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    strIds must be type array.</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="[10,25]">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl8" type="button" role="tab"
                                                                aria-controls="cUrl8"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab8" data-bs-toggle="pill"
                                                                data-bs-target="#PHP8" type="button" role="tab"
                                                                aria-controls="PHP8"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby8" type="button" role="tab"
                                                                aria-controls="Ruby8"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js8"
                                                                type="button" role="tab" aria-controls="Node-js8"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python8" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js8" role="tabpanel"
                                                     aria-labelledby="Node-js-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/unsubscribes-groups/recipients-bulk-delete',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY',
    'Content-Type': 'application/x-www-form-urlencoded'
  },
  form: {
    'strIds[0]': '8',
    'strIds[1]': '44'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python8" role="tabpanel"
                                                     aria-labelledby="Python-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/unsubscribes-groups/recipients-bulk-delete"

payload='strIds%5B0%5D=8&strIds%5B1%5D=44'
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY',
  'Content-Type': 'application/x-www-form-urlencoded'
}

response = requests.request("POST", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP8" role="tabpanel"
                                                     aria-labelledby="PHP-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/unsubscribes-groups/recipients-bulk-delete',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'strIds%5B0%5D=8&strIds%5B1%5D=44',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY',
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl8" role="tabpanel"
                                                     aria-labelledby="cUrl-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/unsubscribes-groups/recipients-bulk-delete' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--header 'Content-Type: application/x-www-form-urlencoded' \
--data-urlencode 'strIds[0]=8' \
--data-urlencode 'strIds[1]=44'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby8" role="tabpanel"
                                                     aria-labelledby="Ruby-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/unsubscribes-groups/recipients-bulk-delete")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
request["Content-Type"] = "application/x-www-form-urlencoded"
request.body = "strIds%5B0%5D=8&strIds%5B1%5D=44"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#OK8"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request8"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request8"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK8" role="tabpanel"
                                                     aria-labelledby="OK-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request8" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>
@endsection

