<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@lang(basicControl()->site_title) | @if(isset($pageSeo['page_title']))
            @lang($pageSeo['page_title'])
        @else
            @yield('title')
        @endif
    </title>
    @include('seo')

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Favicon-link -->
    <link rel="shortcut icon" href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}"
          type="image/x-icon">
    @include($theme.'partials.style')
</head>

<body onload="preloder_function()" class="">

<!-- Preloader section start -->
<div id="preloader">
    <div class="loader"></div>
</div>
<!-- Preloader section end -->
@include($theme.'partials.header')
@include($theme.'partials.banner')

@yield('content')

@include($theme.'partials.footer')

@include('plugins')
@include($theme.'partials.script')
@stack('extra_scripts')
@include($theme.'partials.user.flash-message')
</body>
<script>
    'use strict'
    var currencySymbol = "{{basicControl()->currency_symbol}}";
    calCredits();
    $(document).on("change", "#prepaidCreditSelect", function () {
        calCredits();
    });

    function calCredits() {
        let price = $("#prepaidCreditSelect").find(':selected').attr('data-price');
        let pricePerCredit = $("#prepaidCreditSelect").find(':selected').attr('data-unit');
        let route = $("#prepaidCreditSelect").find(':selected').attr('data-route');
        $('#getCredit').attr('href', route);
        $('#showAddonPrice').text(`${currencySymbol}${price}`);
        $('#showAddonPerRate').text(`${currencySymbol}${pricePerCredit} per credit`);
    }
</script>
</html>
