<!-- Feature section start -->
@if(isset($features['single']))
    <section class="feature-section">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-lg-5">
                    <div class="feature-content">
                        <div class="section-header">
                            <div class="section-subtitle">{{ @$features['single']['title'] }}</div>
                            <h2 class="section-title">{{ @$features['single']['heading'] }}
                            </h2>
                        </div>
                        <p class="cmn-para-text mx-auto">{!! @$features['single']['description'] !!}</p>
                    </div>
                </div>
                @if(isset($features['multiple']) && count($features['multiple']) > 0)
                    <div class="col-lg-7">
                        @foreach($features['multiple'] as $key => $feature)
                            <div class="feature-box {{($key % 2 == 0) ? '':'feature-box-right'}}">
                                <div class="icon-box">
                                    {{++$key}}
                                </div>
                                <div class="text-box">
                                    <h5>{{$feature['heading']}}</h5>
                                    <span>{!! $feature['short_description'] !!}</span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </section>
@endif
<!-- Feature section end -->
