<!-- How it works section start -->
@if(isset($how_it_works))
    <section class="how-it-work">
        <div class="container">
            @if(isset($how_it_works['single']))
                <div class="row">
                    <div class="col-12">
                        <div class="section-header text-center mb-50">
                            <div class="section-subtitle">{{@$how_it_works['single']['title']}}</div>
                            <h2>{{@$how_it_works['single']['heading']}} </h2>
                            <p class="cmn-para-text mx-auto">{!! @$how_it_works['single']['description'] !!}
                            </p>
                        </div>
                    </div>
                </div>
            @endif
            <div class="row g-5 align-items-center">
                <div class="col-md-7 order-2 order-md-1">
                    <div class="how-it-work-content">
                        @if(isset($how_it_works['multiple']) && count($how_it_works['multiple']) > 0)
                            @foreach($how_it_works['multiple'] as $key => $how_it_work)
                                <div class="feature-box {{($key % 2 == 0) ? '':'feature-box-right'}}">
                                    <div class="icon-box">
                                        {{++$key}}
                                    </div>
                                    <div class="text-box">
                                        <h5>{{@$how_it_work['heading']}}</h5>
                                        <span>{!! @$how_it_work['short_description'] !!}</span>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                        <div class="btn-area">
                            <a href="{{ @$how_it_works['single']['media']->my_link }}"
                               class="cmn-btn">{{ @$how_it_works['single']['button_name'] }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-5  order-1 order-md-2">
                    <div class="how-it-work-thums d-flex justify-content-center">
                        <img src="{{$how_it_works['mediaFile']}}" alt="...">
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
<!-- How it works section start -->
