@extends($theme.'layouts.user')
@section('page_title',__('Api Key'))

@section('content')
    <div class="section dashboard">
        <div class="row">
            <div class="col-md-6">
                <div class="account-settings-profile-section">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">@lang('Api Key')
                            </h5>
                        </div>
                        <div class="card-body pt-0">
                            <div class="profile-form-section">
                                <div class="row g-3">
                                    <form>
                                        <div class="col-md-12">
                                            <label for="PublicKey" class="form-label">@lang('Public Key:')</label>
                                            <div class="input-group mb-3">
                                                <input type="text" class="form-control" id="public"
                                                       aria-describedby="button-public"
                                                       value="{{auth()->user()->public_key}}" readonly>
                                                <button class="cmn-btn" type="button" onclick="copyPublic()"
                                                        id="button-public">@lang('Copy')</button>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="SecretKey" class="form-label">@lang('Secret Key:')</label>
                                            <div class="input-group mb-3">
                                                <input type="text" class="form-control" id="secret"
                                                       aria-describedby="button-secret"
                                                       value="{{auth()->user()->secret_key}}" readonly>
                                                <button class="cmn-btn" type="button" onclick="copySecret()"
                                                        id="button-secret">@lang('Copy')</button>
                                            </div>
                                        </div>
                                        <button type="button" class="cmn-btn mt-3" data-bs-target="#confirmModal"
                                                data-bs-toggle="modal">
                                            @lang('Generate Api Key')
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="account-settings-profile-section">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h5 class="card-title">@lang('Webhook')
                                </h5>
                                <button class="cmn-btn" data-bs-target="#addUrl"
                                        data-bs-toggle="modal">@lang('Create New')</button>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="profile-form-section">
                                <div class="row g-3">
                                    <form>
                                        @if(auth()->check() && auth()->user()->webhook_url)
                                            @foreach(auth()->user()->webhook_url as $url)
                                                <div class="col-md-12">
                                                    <label for="Created_At"
                                                           class="form-label">@lang('Created At: '){{$url->created_at}}</label>
                                                    <div class="input-group mb-3">
                                                        <input type="text" class="form-control" id="secret"
                                                               aria-describedby="button-secret"
                                                               value="{{$url->url}}"
                                                               readonly>
                                                        <button class="cmn-btn color-red deleteConfirm"
                                                                data-bs-target="#deleteModal" data-bs-toggle="modal"
                                                                data-route="{{route('user.webhookDelete',$url->code)}}"
                                                                type="button">@lang('Delete')</button>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <p class="text-center">@lang('No data found')</p>
                                        @endif
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">@lang('Confirmation')</h5>
                    <button type="button" class="cmn-btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="{{route('user.apiKey')}}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <p>@lang('Are you certain about generating a new API key? If you proceed with generating a new key, the previously used API key may be invalidated or affected. Please confirm before initiating the process to avoid any disruption.')</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cmn-btn3"
                                data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="cmn-btn">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addUrl" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">@lang('Add Webhook Url')</h5>
                    <button type="button" class="cmn-btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="{{route('user.webhookSet')}}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <label for="WebhookUrl" class="form-label">@lang('Webhook Url:')</label>
                        <input type="text" class="form-control" name="webhook_url"
                               aria-describedby="button-secret">
                        @error('webhook_url')
                        <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cmn-btn3"
                                data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="cmn-btn">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">@lang('Delete Confirmation')</h5>
                    <button type="button" class="cmn-btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="" method="get" class="deleteForm">
                    <div class="modal-body">
                        <p>@lang('Are you want to delete this webhook url.')</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cmn-btn3"
                                data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="cmn-btn">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@push('extra_scripts')
    <script>
        'use strict';

        $(document).on("click", ".deleteConfirm", function () {
            let route = $(this).data('route');
            $('.deleteForm').attr('action', route)
        });

        function copyPublic() {
            var copyText = document.getElementById("public");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.success(`Copied: ${copyText.value}`);
        }

        function copySecret() {
            var copyText = document.getElementById("secret");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.success(`Copied: ${copyText.value}`);
        }
    </script>
    @if ($errors->any())
        @php
            $collection = collect($errors->all());
            $errors = $collection->unique();
        @endphp
        <script>
            "use strict";
            @foreach ($errors as $error)
            Notiflix.Notify.failure("{{ trans($error) }}");
            @endforeach
        </script>
    @endif
@endpush
