<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UnsubscribeController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\SenderController;
use App\Http\Controllers\Api\CustomFieldsController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\SingleSendController;
use App\Http\Controllers\Api\AutomationController;
use App\Http\Controllers\Api\SegmentController;
use App\Http\Controllers\User\SubscriptionController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::any('subscription/{code}/{utr?}', [SubscriptionController::class, 'subscriptionIpn'])->name('subscription.ipn');

Route::middleware(['checkAuthenticate'])->group(function () {

    //SENDER
    Route::controller(SenderController::class)->group(function () {
        Route::get('senders', 'index');
        Route::get('get/country-state-city', 'getCountryStateCity');
        Route::post('sender/save', 'senderSave');
        Route::get('sender/details', 'senderDetails');
        Route::post('sender/update', 'senderUpdate');
        Route::get('sender/resend-mail', 'senderSendMail');
        Route::delete('sender/delete', 'senderDelete');
    });

    //EMAIL NOTIFICATION
    Route::controller(NotificationController::class)->group(function () {
        Route::get('notification-recipients', 'index');
        Route::post('notification-recipient/save', 'emailNotificationSave');
        Route::delete('notification-recipient/delete', 'emailNotificationDelete');
        Route::post('notification-recipient/bulk-delete', 'emailNotificationBulkDelete');
    });

    //UNSUBSCRIBE
    Route::controller(UnsubscribeController::class)->group(function () {
        Route::get('unsubscribes-groups', 'unsubscribesGroup');
        Route::post('unsubscribes-groups/save', 'unsubscribesGroupSave');
        Route::get('unsubscribes-groups/details', 'unsubscribesGroupEdit');
        Route::post('unsubscribes-groups/update', 'unsubscribesGroupUpdate');
        Route::post('unsubscribes-groups/manually-add', 'unsubscribesGroupManuallyAdd');
        Route::get('unsubscribes-groups/recipients-list', 'unsubscribesRecipients');
        Route::delete('unsubscribes-groups/recipients-delete', 'unsubscribesRecipientDelete');
        Route::post('unsubscribes-groups/recipients-bulk-delete', 'unsubscribesRecipientBulkDelete');

        Route::get('global-unsubscribes', 'globalUnsubscribes');
        Route::post('global-unsubscribes/save', 'globalUnsubscribesSave');
        Route::delete('global-unsubscribes/delete', 'globalUnsubscribesDelete');
        Route::post('global-unsubscribes/bulk-delete', 'globalUnsubscribesBulkDelete');
    });

    //CUSTOM FIELDS
    Route::controller(CustomFieldsController::class)->group(function () {
        Route::get('reserve-fields', 'reserveField');
        Route::get('custom-fields', 'customField');
        Route::post('custom-fields/save', 'customFieldSave');
        Route::delete('custom-fields/delete', 'customFieldDelete');
    });

    //CONTACT
    Route::controller(ContactController::class)->group(function () {
        Route::get('contacts-type', 'contactTypeList');
        Route::post('contacts-type/add', 'contactTypeSave');
        Route::get('contacts-type/view', 'contactTypeView');
        Route::post('contacts-type/update', 'contactTypeUpdate');
        Route::delete('contacts-type/delete', 'contactTypeDelete');

        Route::get('contacts/list', 'contactList');
        Route::post('contacts/add', 'contactAdd');
        Route::get('contacts/csv-sample/download', 'contactCsvSample');
        Route::post('contacts/upload-csv', 'contactUploadCsv');
        Route::get('contacts/details', 'contactDetail');
        Route::post('contacts/update', 'contactUpdate');
        Route::delete('contacts/delete', 'contactDelete');
        Route::post('contacts/bulk-delete', 'contactBulkDelete');
    });

    //SINGLE SENDS
    Route::controller(SingleSendController::class)->group(function () {
        Route::get('get-design/template', 'getTemplate');
        Route::get('get-dynamic/content', 'getDynamicContent');
        Route::get('single-send/list', 'index');
        Route::post('single/send/create', 'singleSendCreate');
        Route::get('single/send/duplicate', 'singleSendDuplicate');
        Route::get('single-send/details', 'singleSendDeatils');
        Route::post('single-send/update', 'singleSendUpdate');
        Route::delete('single/send/delete', 'singleSendDelete');
        Route::post('single/send/bulk-delete', 'singleSendBulkDelete');
    });

    //Automation
    Route::controller(AutomationController::class)->group(function () {
        Route::get('automations', 'index');
        Route::post('automations/create', 'automationCreate');
        Route::get('automations/duplicate', 'automationDuplicate');
        Route::get('automations/details', 'automationDetails');
        Route::get('automations/schedule', 'automationSchedule');
        Route::get('automations/pause', 'automationPause');
        Route::get('automations/set-live', 'automationSetLive');
        Route::delete('automations/delete', 'automationDelete');
        Route::post('automations/bulk-delete', 'automationBulkDelete');

        Route::post('automations/schedule/create', 'automationScheduleCreate');
        Route::delete('automations/schedule/delete', 'automationScheduleDelete');
    });

    //SEGMENT
    Route::controller(SegmentController::class)->group(function () {
        Route::get('segment/list', 'index');
        Route::get('segment/email/list', 'segmentEmailList');
        Route::post('segment/email/store', 'segmentEmailStore');
        Route::delete('segment/email/delete', 'segmentEmailDelete');
        Route::delete('segment/delete', 'segmentDelete');
    });
});

