<!-- Pricing plan section start -->
<?php if(isset($pricing)): ?>
    <section class="pricing-section">
        <div class="container">
            <?php if(isset($pricing['single'])): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="section-header text-center">
                            <div class="section-subtitle"><?php echo e(@$pricing['single']['title']); ?></div>
                            <h2 class="section-title mx-auto"><?php echo e(@$pricing['single']['heading']); ?></h2>
                            <p class="cmn-para-text mx-auto"><?php echo e(@$pricing['single']['short_description']); ?>

                            </p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php
                $plans = \App\Models\Plan::where('status',1)->where('is_free',0)->get();
                $freePlan = \App\Models\Plan::where('status',1)->where('is_free',1)->first();
                $prepaidCredits = \App\Models\PrepaidCredit::where('status',1)->orderBy('credits','ASC')->get();
            ?>

            <div class="row">
                <div class="col-12">
                    <!-- Cmn tabs start -->
                    <div class="cmn-tabs">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <?php if(count($prepaidCredits) > 0): ?>
                                    <button class="nav-link" id="credit-plan-tab" data-bs-toggle="pill"
                                            data-bs-target="#credit-plan" type="button" role="tab"
                                            aria-controls="credit-plan"
                                            aria-selected="false">
                                        <h5><?php echo app('translator')->get('Add-ons'); ?></h5>
                                        <p class="mb-0"><?php echo app('translator')->get('All'); ?>
                                            <?php echo e(basicControl()->site_title); ?> <?php echo app('translator')->get('plans can access Email Verification'); ?></p>
                                    </button>
                                <?php endif; ?>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="monthly-plan-tab" data-bs-toggle="pill"
                                        data-bs-target="#monthly-plan" type="button" role="tab"
                                        aria-controls="monthly-plan"
                                        aria-selected="false">
                                    <h5><?php echo app('translator')->get('Monthly'); ?></h5>
                                    <p class="mb-0"><?php echo app('translator')->get('Subscribe to our monthly plan for uninterrupted access to premium features'); ?></p>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="yearly-plan-tab" data-bs-toggle="pill"
                                        data-bs-target="#yearly-plan" type="button" role="tab"
                                        aria-controls="yearly-plan"
                                        aria-selected="false">
                                    <h5><?php echo app('translator')->get('Yearly'); ?></h5>
                                    <p class="mb-0"><?php echo app('translator')->get('Subscribe to our yearly plan for uninterrupted access to premium features'); ?></p>
                                </button>
                            </li>

                        </ul>
                    </div>
                    <!-- Cmn tabs end -->

                    <!-- Cmn tab content start -->
                    <div class="cmn-tab-content">
                        <div class="tab-content" id="pills-tabContent">
                            <?php if(count($prepaidCredits) > 0): ?>
                                <div class="tab-pane fade" id="credit-plan" role="tabpanel"
                                     aria-labelledby="credit-plan-tab" tabindex="0">
                                    <div class="cmn-tab-content">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="section-header text-center">
                                                    <h3 class="section-title mx-auto"><?php echo app('translator')->get('Prepaid Credits'); ?></h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row g-4 justify-content-center">
                                            <div class="col-md-6">
                                                <div class="prepaid-credit-box">
                                                    <div class="prepaid-header">
                                                        <div class="title">
                                                            <i class="fa-regular fa-circle-check"></i>
                                                            <h4><?php echo app('translator')->get('Email verification'); ?> </h4>
                                                        </div>
                                                        <p><?php echo app('translator')->get('Verify email addresses in bulk or real-time.'); ?></p>
                                                    </div>
                                                    <div class="prepaid-body mt-20">
                                                        <label
                                                            class="form-label"><?php echo app('translator')->get('How many credits do you need?'); ?></label>
                                                        <select class="js-example-basic-single form-control"
                                                                name="prepaidCredit"
                                                                id="prepaidCreditSelect">
                                                            <?php $__currentLoopData = $prepaidCredits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prepaidCredit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    value="<?php echo e($prepaidCredit->id); ?>"
                                                                    data-price="<?php echo e($prepaidCredit->price); ?>"
                                                                    data-unit="<?php echo e(getAmount($prepaidCredit->per_credit_price,5)); ?>"
                                                                    data-route="<?php echo e(route('user.creditsPurchase').'?id='.$prepaidCredit->id); ?>"><?php echo e(getAmount($prepaidCredit->credits,5)); ?> <?php echo app('translator')->get('credits'); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <h3 class="mt-20 mb-0" id="showAddonPrice">$0</h3>
                                                        <div class="d-flex justify-content-between">
                                                            <h6 id="showAddonPerRate">$0 per credit</h6>
                                                            <a href=""
                                                               class="cmn-btn text-end mb-2"
                                                               id="getCredit"><?php echo app('translator')->get('Get Credits'); ?></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Email API Plans tab content start -->
                            <div class="tab-pane fade show active" id="monthly-plan" role="tabpanel"
                                 aria-labelledby="monthly-plan-tab" tabindex="0">
                                <div class="cmn-tab-content">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="section-header text-center">
                                                <h3 class="section-title mx-auto"><?php echo app('translator')->get('Monthly Plans'); ?></h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-4">
                                        <?php if($freePlan): ?>
                                            <div class="col-xxl-3 col-lg-4 col-md-6">
                                                <div
                                                    class="pricing-box <?php echo e((auth()->check() && optional(auth()->user()->plan)->plan_id == $freePlan->id) ? 'featured':''); ?>">
                                                    <?php if(auth()->check() && optional(auth()->user()->plan)->plan_id == $freePlan->id): ?>
                                                        <div class="featured-title"><?php echo app('translator')->get('Running'); ?></div>
                                                    <?php endif; ?>
                                                    <div class="section-header">
                                                        <h3 class="section-title"><?php echo e($freePlan->plan_name); ?></h3>
                                                        <p class="plan-description"><?php echo e($freePlan->description); ?></p>
                                                    </div>
                                                    <div class="section-body">

                                                        <div class="title">
                                                            <span><?php echo e(basicControl()->currency_symbol); ?>0</span><?php echo app('translator')->get('/month'); ?>
                                                        </div>

                                                        <div class="plan-thumbs">
                                                            <img
                                                                src="<?php echo e($themeTrue.'img/pricing-plan/paper-plane2.png'); ?>"
                                                                alt="">
                                                        </div>
                                                        <div class="btn-area">
                                                            <a href="<?php echo e(route('user.subscriptionPurchaseFree').'?id='.$freePlan->id); ?>"
                                                               class="cmn-btn"><?php echo app('translator')->get('Start free trial'); ?>
                                                            </a>
                                                        </div>
                                                        <ul class="pricing-feature">
                                                            <li>
                                                                <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($freePlan->number_of_emails); ?> <?php echo app('translator')->get('emails'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($freePlan->number_of_contacts); ?> <?php echo app('translator')->get('contacts'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid fa-check"></i><?php echo e(strtoupper($freePlan->sending_server)); ?> <?php echo app('translator')->get('Server'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->design_and_code_editors?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Drag & Drop Editor'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->automation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Automation'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->single_send?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Single Send'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->segmentation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Segmentation'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->custom_field?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Custom Field'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->notify_recipient?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Notify Recipients'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->activities?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('User Activities'); ?>
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid <?php echo e($freePlan->api_uses?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make API Implementation'); ?>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($plans): ?>
                                            <?php $__currentLoopData = $plans->where('payment_frequency','monthly'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xxl-3 col-lg-4 col-md-6">
                                                    <div
                                                        class="pricing-box <?php echo e((auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id) ? 'featured':''); ?>">
                                                        <?php if(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id): ?>
                                                            <div class="featured-title"><?php echo app('translator')->get('Running'); ?></div>
                                                        <?php endif; ?>
                                                        <div class="section-header">
                                                            <h3 class="section-title"><?php echo e($plan->plan_name); ?></h3>
                                                            <p class="plan-description"><?php echo e($plan->description); ?></p>
                                                        </div>
                                                        <div class="section-body">

                                                            <div class="title">
                                                                <span><?php echo e(basicControl()->currency_symbol); ?><?php echo e($plan->price); ?></span><?php echo app('translator')->get('/month'); ?>
                                                            </div>

                                                            <div class="plan-thumbs">
                                                                <img
                                                                    src="<?php echo e($themeTrue.'img/pricing-plan/paper-plane2.png'); ?>"
                                                                    alt="">
                                                            </div>
                                                            <div class="btn-area">
                                                                <a href="<?php echo e(route('user.subscriptionPurchase').'?id='.$plan->id); ?>"
                                                                   class="cmn-btn"><?php echo app('translator')->get('Subscription'); ?>
                                                                </a>
                                                            </div>
                                                            <ul class="pricing-feature">
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($plan->number_of_emails); ?> <?php echo app('translator')->get('emails'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($plan->number_of_contacts); ?> <?php echo app('translator')->get('contacts'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo e(strtoupper($plan->sending_server)); ?> <?php echo app('translator')->get('Server'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->design_and_code_editors?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Drag & Drop Editor'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->automation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Automation'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->single_send?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Single Send'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->segmentation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Segmentation'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->custom_field?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Custom Field'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->notify_recipient?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Notify Recipients'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->activities?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('User Activities'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->api_uses?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make API Implementation'); ?>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <!-- Email API Plans tab content end -->

                            <!-- Marketing Campaigns Plans tab content start -->
                            <div class="tab-pane fade" id="yearly-plan" role="tabpanel"
                                 aria-labelledby="yearly-plan-tab" tabindex="0">
                                <div class="cmn-tab-content">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="section-header text-center">
                                                <h3 class="section-title mx-auto"><?php echo app('translator')->get('Yearly Plans'); ?></h3>
                                                <span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-5">
                                        <?php if($plans): ?>
                                            <?php $__currentLoopData = $plans->where('payment_frequency','yearly'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-lg-4 col-md-6">
                                                    <div
                                                        class="pricing-box <?php echo e((auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id) ? 'featured':''); ?>">
                                                        <?php if(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id): ?>
                                                            <div class="featured-title"><?php echo app('translator')->get('Running'); ?></div>
                                                        <?php endif; ?>
                                                        <div class="section-header">
                                                            <h3 class="section-title"><?php echo e($plan->plan_name); ?></h3>
                                                            <p class="plan-description"><?php echo e($plan->description); ?></p>
                                                        </div>
                                                        <div class="section-body">

                                                            <div class="title">
                                                                <span><?php echo e(basicControl()->currency_symbol); ?><?php echo e($plan->price); ?></span><?php echo app('translator')->get('/year'); ?>
                                                            </div>

                                                            <div class="plan-thumbs">
                                                                <img
                                                                    src="<?php echo e($themeTrue.'img/pricing-plan/paper-plane2.png'); ?>"
                                                                    alt="">
                                                            </div>
                                                            <div class="btn-area">
                                                                <a href="<?php echo e(route('user.subscriptionPurchase').'?id='.$plan->id); ?>"
                                                                   class="cmn-btn"><?php echo app('translator')->get('Subscription'); ?>
                                                                </a>
                                                            </div>

                                                            <ul class="pricing-feature">
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($plan->number_of_emails); ?> <?php echo app('translator')->get('emails'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo app('translator')->get('Upto '); ?><?php echo e($plan->number_of_contacts); ?> <?php echo app('translator')->get('contacts'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i><?php echo e(strtoupper($plan->sending_server)); ?> <?php echo app('translator')->get('Server'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->design_and_code_editors?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Drag & Drop Editor'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->automation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Automation'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->single_send?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Single Send'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->segmentation?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make Segmentation'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->custom_field?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Custom Field'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->notify_recipient?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Add Notify Recipients'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->activities?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('User Activities'); ?>
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid <?php echo e($plan->api_uses?'fa-check':'fa-xmark close'); ?>"></i><?php echo app('translator')->get('Make API Implementation'); ?>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <!-- Marketing Campaigns Plans tab content end -->
                        </div>
                    </div>
                    <!-- Cmn tab content end -->
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH D:\server\htdocs\swift-send\project\resources\views/themes/light/sections/pricing.blade.php ENDPATH**/ ?>