<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo app('translator')->get(basicControl()->site_title); ?> | <?php if(isset($pageSeo['page_title'])): ?>
            <?php echo app('translator')->get($pageSeo['page_title']); ?>
        <?php else: ?>
            <?php echo $__env->yieldContent('title'); ?>
        <?php endif; ?>
    </title>
    <?php echo $__env->make('seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Favicon-link -->
    <link rel="shortcut icon" href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>"
          type="image/x-icon">
    <?php echo $__env->make($theme.'partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body onload="preloder_function()" class="">

<!-- Preloader section start -->
<div id="preloader">
    <div class="loader"></div>
</div>
<!-- Preloader section end -->
<?php echo $__env->make($theme.'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($theme.'partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('extra_scripts'); ?>
<?php echo $__env->make($theme.'partials.user.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<script>
    'use strict'
    var currencySymbol = "<?php echo e(basicControl()->currency_symbol); ?>";
    calCredits();
    $(document).on("change", "#prepaidCreditSelect", function () {
        calCredits();
    });

    function calCredits() {
        let price = $("#prepaidCreditSelect").find(':selected').attr('data-price');
        let pricePerCredit = $("#prepaidCreditSelect").find(':selected').attr('data-unit');
        let route = $("#prepaidCreditSelect").find(':selected').attr('data-route');
        $('#getCredit').attr('href', route);
        $('#showAddonPrice').text(`${currencySymbol}${price}`);
        $('#showAddonPerRate').text(`${currencySymbol}${pricePerCredit} per credit`);
    }
</script>
</html>
<?php /**PATH D:\xamp\htdocs\swift-send\resources\views/themes/light/layouts/app.blade.php ENDPATH**/ ?>