<?php $__env->startSection('page_title', __(optional($page->details)->name ?? ucfirst($page->name) . ' Page SEO')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="<?php echo e(route('admin.page.index', basicControl()->theme)); ?>"><?php echo app('translator')->get('Pages'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get(optional($page->details)->name ??  ucfirst($page->name) . ' Page SEO'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get(optional($page->details)->name ?? ucfirst($page->name) . ' Page SEO'); ?></h1>
                </div>
            </div>
        </div>

        <div class="row d-flex justify-content-center">
            <div class="col-lg-8">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h2 class="card-title h4"><?php echo app('translator')->get(optional($page->details)->name ?? ucfirst($page->name) . ' Page SEO'); ?></h2>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.page.seo.update', $page->id)); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <div class="row">
                                    <div class="col-sm-12 mb-3">
                                        <label for="PageTitleLabel" class="form-label"><?php echo app('translator')->get('Page Title'); ?></label>
                                        <input type="text"
                                               class="form-control <?php $__errorArgs = ['page_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="page_title" id="PageTitleLabel"
                                               placeholder="<?php echo app('translator')->get("Page Title"); ?>" aria-label="<?php echo app('translator')->get("Page Title"); ?>"
                                               value="<?php echo e(old('page_title', $page->page_title)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['page_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12 mb-3">
                                        <label for="SeoTitleLabel" class="form-label"><?php echo app('translator')->get('Meta Title'); ?></label>
                                        <input type="text"
                                               class="form-control <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="meta_title" id="SeoTitleLabel"
                                               placeholder="<?php echo app('translator')->get("Meta Title"); ?>" aria-label="<?php echo app('translator')->get("Meta Title"); ?>"
                                               value="<?php echo e(old('meta_title', $page->meta_title)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12 mb-3">
                                        <label for="metaKeywordLabel" class="form-label"><?php echo app('translator')->get('Meta Keywords'); ?></label>
                                        <div class="tom-select-custom">
                                            <select class="js-select form-select" name="meta_keywords[]"
                                                    autocomplete="off" multiple
                                                    data-hs-tom-select-options='{
                                                        "create": true,
                                                        "placeholder": "Meta Keywords"
                                                    }'>
                                                <?php if($page->meta_keywords): ?>
                                                    <?php $__currentLoopData = $page->meta_keywords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo app('translator')->get($data); ?>" selected><?php echo app('translator')->get($data); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ["meta_keywords"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 mb-3">
                                        <label for="metaDescription"
                                               class="form-label"><?php echo app('translator')->get('Meta Description'); ?></label>
                                        <textarea id="metaDescription" class="form-control" name="meta_description"
                                                  placeholder="<?php echo app('translator')->get("Meta Description"); ?>"
                                                  rows="4"><?php echo e(old("meta_description", $page->meta_description)); ?></textarea>
                                        <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-12 mb-3">
                                        <label for="ogDescription"
                                               class="form-label"><?php echo app('translator')->get('OG Description'); ?></label>
                                        <textarea id="ogDescription" class="form-control" name="og_description"
                                                  placeholder="<?php echo app('translator')->get("OG Description"); ?>"
                                                  rows="4"><?php echo e(old("og_description", $page->og_description)); ?></textarea>
                                        <?php $__errorArgs = ['og_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                                <div class="row mb-3">
                                    <label class="form-label"><?php echo app('translator')->get("Meta Robots"); ?></label>
                                    <div class="tom-select-custom tom-select-custom-with-tags">
                                        <select class="js-select form-select meta-robot-select2" autocomplete="off"
                                                name="meta_robots[]" multiple
                                                data-hs-tom-select-options='{
                                                    "placeholder": "Select Meta Robots"
                                                  }'>
                                            <option
                                                value="index" <?php echo e(in_array("index", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                Index
                                            </option>
                                            <option
                                                value="noindex" <?php echo e(in_array("noindex", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                No index
                                            </option>
                                            <option
                                                value="follow" <?php echo e(in_array("follow", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                Follow
                                            </option>
                                            <option
                                                value="nofollow" <?php echo e(in_array("nofollow", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                No follow
                                            </option>
                                            <option
                                                value="noarchive" <?php echo e(in_array("noarchive", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                Noarchive
                                            </option>
                                            <option
                                                value="nosnippet" <?php echo e(in_array("nosnippet", $page->getMetaRobots()) ? 'selected' : ''); ?>>
                                                Nosnippet
                                            </option>
                                        </select>
                                    </div>
                                    <!-- End Select -->
                                </div>

                                <div class="row">
                                    <div class="col-md-5 mb-3 mb-md-0">
                                        <label class="form-label"><?php echo app('translator')->get("Meta Image"); ?></label>
                                        <label class="form-check form-check-dashed" for="imageUploader">
                                            <img id="SeoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2"
                                                 src="<?php echo e(getFile($page->meta_image_driver, $page->meta_image, true)); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="default">
                                            <img id="SeoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2"
                                                 src="<?php echo e(getFile($page->meta_image_driver, $page->meta_image, true)); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="dark">
                                            <span class="d-block"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach form-check-input"
                                                   id="imageUploader" name="meta_image"
                                                   data-hs-file-attach-options='{
                                                  "textTarget": "#SeoImg",
                                                  "mode": "image",
                                                  "targetAttr": "src",
                                                  "allowTypes": [".png", ".jpeg", ".jpg", ".json"]
                                               }'>
                                        </label>
                                        <?php $__errorArgs = ['meta_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end mt-3">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/hs-file-attach.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            new HSFileAttach('.js-file-attach')
            HSCore.components.HSTomSelect.init('.js-select')
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\swift-send\project\resources\views/admin/frontend_management/page/seo.blade.php ENDPATH**/ ?>